% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R, R/likelihood_ratio.R
\name{anova.PlackettLuce}
\alias{anova.PlackettLuce}
\alias{likelihood_ratio}
\title{Likelihood-ratio test}
\usage{
\method{anova}{PlackettLuce}(object, ...)

likelihood_ratio(x, split, ...)
}
\arguments{
\item{object}{an object of class PlackettLuce}

\item{...}{additional arguments passed to methods}

\item{x}{an object of class rankings or grouped_rankings}

\item{split}{a vector indicating the splitting rule for the test}
}
\description{
Assesses the goodness of fit of competing
 statistical models
}
\examples{
library("PlackettLuce")
example("beans", package = "PlackettLuce")
G = group(R, rep(seq_len(nrow(beans)), 4))
d = cbind(G, beans)

split = ifelse(d$maxTN < 18.7175, TRUE, FALSE)

likelihood_ratio(G, split)

mod = PlackettLuce(G)

anova(mod)

}
\author{
Joost van Heerwaarden and Kauê de Sousa
}
