% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{balanced}
\alias{balanced}
\title{Balanced operator}
\usage{
balanced(f, ...)
}
\arguments{
\item{f}{A function.}

\item{...}{Deprecated. Additional arguments to \code{f} that should \emph{not} be
balanced.}
}
\value{
A function like \code{f} with a new argument \code{na.rm}. If \code{na.rm = TRUE} then
\code{\link[=complete.cases]{complete.cases()}} is used to remove missing values across all inputs
prior to calling \code{f}.
}
\description{
Makes a function balance the removal of \code{NA}s across multiple input vectors.
}
\examples{
p2 <- price6[[3]]
p1 <- price6[[2]]
q2 <- quantity6[[3]]
q1 <- quantity6[[2]]

# Balance missing values for a Fisher index.

fisher <- balanced(fisher_index)
fisher(p2, p1, q2, replace(q1, 3, NA), na.rm = TRUE)
fisher_index(p2[-3], p1[-3], q2[-3], q1[-3])

}
\seealso{
Other operators: 
\code{\link{grouped}()},
\code{\link{quantity_index}()}
}
\concept{operators}
