% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gprofiler_request}
\alias{gprofiler_request}
\title{Perform a g:Profiler API request}
\usage{
gprofiler_request(url, payload)
}
\arguments{
\item{url}{The URL to which the request is sent.}

\item{payload}{The payload to be sent in the request body. It should be a list or JSON string.}
}
\value{
A list containing the parsed JSON response from the g:Profiler API.
}
\description{
This function sends an HTTP POST request to the g:Profiler API with the provided payload
and handles the response accordingly. It parses the JSON response and returns the result.
}
\details{
This function sends an HTTP POST request to the specified URL with the provided payload,
expecting a JSON response. It handles potential errors, such as non-200 response codes,
and parses the JSON response accordingly. If the response code is not 200, an error is raised
along with a descriptive message. If the response contains a JSON object with a "message" field,
this message is included in the error message.
}
\examples{
# Example usage:
url <- "https://biit.cs.ut.ee/gprofiler/api/gost/profile"
payload <- list(
  organism = jsonlite::unbox("hsapiens"),
  query = c("ENSG00000139618", "ENSG00000141510"),
  sources = c("GO:BP", "KEGG"),
  user_threshold = jsonlite::unbox(0.05),
  all_results = jsonlite::unbox(TRUE)
)
\dontrun{result <- gprofiler_request(url, payload)}

}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
