% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_plans_oc.R
\name{compare_plans_oc}
\alias{compare_plans_oc}
\title{Comparison based on OC curve}
\usage{
compare_plans_oc(c1, c2, c3, r1, t1, r2, t2, r3, t3, distribution, K, m, sd)
}
\arguments{
\item{c1, c2, c3}{acceptance numbers}

\item{r1, r2, r3}{number of primary increments in a grab sample or grab sample size}

\item{t1, t2, t3}{number of grab samples}

\item{distribution}{what distribution we have used such as   \code{'Poisson gamma'} or \code{'Lognormal'}or \code{'Poisson lognormal'}}

\item{K}{dispersion parameter of the Poisson gamma distribution (default value 0.25)}

\item{m}{microbiological limit with default value zero, generally expressed as number of microorganisms in specific sample weight}

\item{sd}{standard deviation of the lognormal and Poisson-lognormal distributions on the log10 scale (default value 0.8)}
}
\value{
overlaid OC curves
}
\description{
This function produces overlaid Operating Characteristic (OC) curves for any three systematic/random sampling schemes for specified parameters.
}
\examples{
c1 <- 0
c2 <- 0
c3 <- 0
r1 <- 25
r2 <- 50
r3 <- 75
t1 <- 10
t2 <- 10
t3 <- 10
distribution <- 'Poisson lognormal'
compare_plans_oc(c1, c2, c3, r1, t1, r2, t2, r3, t3, distribution)
}
\seealso{
\link{prob_accept}
}
