% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_contaminant.R
\name{prob_contaminant}
\alias{prob_contaminant}
\title{Probability of contaminated sample}
\usage{
prob_contaminant(l, r, t, d, p, N, method)
}
\arguments{
\item{l}{number of contaminated in \code{t} selected samples}

\item{r}{number of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{d}{serial correlation of contamination between the primary increments}

\item{p}{limiting fraction or proportion of contaminated increments}

\item{N}{length of the production}

\item{method}{what sampling method we have applied such as \code{'systematic'} or \code{'random'} selection methods}
}
\value{
Probability of contaminated
}
\description{
This function calculates the probability of exactly  \code{l}  contaminated samples out of \code{t} selected grab samples for given gram sample size \code{r} and serial correlation \code{d} at the process contamination level \code{p} for a production length of \code{N}.
}
\details{
Let \eqn{S_t} be the number of contaminated samples and \eqn{S_t=\sum X_t} where \eqn{X_t=1} or \eqn{0} depending on the presence or absence of contamination, then \eqn{P(S_t=l)} formula given in \href{https://doi.org/10.2307/1427041}{Bhat and Lal (1988)}, also we can use following recurrence relation formula,
\deqn{P(S_t=l)=P(X_t=1;S_{t-1}=l-1) + P(X_t=0;S_{t-1}=l)} which is given in \href{https://onlinelibrary.wiley.com/doi/abs/10.1002/nav.1028}{Vellaisamy and Sankar (2001)}. Both methods will be produced the same results.
For this package development, we directly applied formula which is from \href{https://doi.org/10.2307/1427041}{Bhat and Lal (1988)}.
}
\examples{
  l <-  1
  r <-  25
  t <-  30
  d <-  0.99
  p <-  0.005
  N <-  1e9
  method <- 'systematic'
  prob_contaminant(l, r, t, d, p, N, method)
}
\references{
\itemize{
\item  Bhat, U., & Lal, R. (1988). Number of successes in Markov trials. Advances in Applied Probability, 20(3), \href{https://doi.org/10.2307/1427041}{677-680}.
\item  Vellaisamy, P., Sankar, S., (2001). Sequential and systematic sampling plans for the Markov-dependent production process. Naval Research Logistics 48, \href{https://onlinelibrary.wiley.com/doi/abs/10.1002/nav.1028}{451-467}.
}
}
\seealso{
\link{prob_detect_single_grab}, \link{correlation_grab}
}
