% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_test_shortcut.R
\name{graph_test_shortcut}
\alias{graph_test_shortcut}
\title{Perform shortcut (sequentially rejective) graphical multiple comparison
procedures}
\usage{
graph_test_shortcut(
  graph,
  p,
  alpha = 0.025,
  verbose = FALSE,
  test_values = FALSE
)
}
\arguments{
\item{graph}{An initial graph as returned by \code{\link[=graph_create]{graph_create()}}.}

\item{p}{A numeric vector of p-values (unadjusted, raw), whose values should
be between 0 & 1. The length should match the number of hypotheses in
\code{graph}.}

\item{alpha}{A numeric scalar of the overall significance level, which should
be between 0 & 1. The default is 0.025 for one-sided hypothesis testing
problems; another common choice is 0.05 for two-sided hypothesis testing
problems.}

\item{verbose}{A logical scalar specifying whether the details of
intermediate update graphs should be included in results. When
\code{verbose = TRUE}, intermediate update graphs are provided after deleting
each hypothesis, which has been rejected. The default is \code{verbose = FALSE}.}

\item{test_values}{A logical scalar specifying whether adjusted significance
levels should be provided for each hypothesis. When \code{test_values = TRUE},
it provides an equivalent way of performing graphical multiple comparison
procedures by comparing each p-value with its significance level. If the
p-value of a hypothesis is less than or equal to its significance level,
the hypothesis is rejected. The order of rejection is based on the order
of adjusted p-values from the smallest to the largest. The default is
\code{test_values = FALSE}.}
}
\value{
An S3 object of class \code{graph_report} with a list of 4 elements:
\itemize{
\item \code{inputs} - Input parameters, which is a list of:
\itemize{
\item \code{graph} - Initial graph,
*\code{p} - (Unadjusted or raw) p-values,
\item \code{alpha} - Overall significance level,
\item \code{test_groups} - Groups of hypotheses for different types of tests,
which are the list of all hypotheses for \code{\link[=graph_test_shortcut]{graph_test_shortcut()}},
\item \code{test_types} - Different types of tests, which are "bonferroni" for
\code{\link[=graph_test_shortcut]{graph_test_shortcut()}}.
}
\item Output parameters \code{outputs}, which is a list of:
\itemize{
\item \code{adjusted_p} - Adjusted p-values,
\item \code{rejected} - Rejected hypotheses,
\item \code{graph} - Updated graph after deleting all rejected hypotheses.
}
\item \code{details} - Verbose outputs with intermediate updated graphs, if
\code{verbose = TRUE}.
\item \code{test_values} - Adjusted significance levels, if \code{test_values = TRUE}.
}
}
\description{
Shortcut graphical multiple comparison procedures are sequentially rejective
procedure based on Bretz et al. (2009). With $m$ hypotheses, there are at
most $m$ steps to obtain all rejection decisions. These procedure are
equivalent to closed graphical multiple comparison procedures using
Bonferroni tests for intersection hypotheses, but shortcut procedures are
faster to perform. See \code{vignette("shortcut-testing")} for more illustration
of shortcut procedures and interpretation of their outputs.
}
\examples{
# A graphical multiple comparison procedure with two primary hypotheses (H1
# and H2) and two secondary hypotheses (H3 and H4)
# See Figure 1 in Bretz et al. (2011).
hypotheses <- c(0.5, 0.5, 0, 0)
transitions <- rbind(
  c(0, 0, 1, 0),
  c(0, 0, 0, 1),
  c(0, 1, 0, 0),
  c(1, 0, 0, 0)
)
g <- graph_create(hypotheses, transitions)

p <- c(0.018, 0.01, 0.105, 0.006)
alpha <- 0.025
graph_test_shortcut(g, p, alpha)
}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical
approach to sequentially rejective multiple test procedures.
\emph{Statistics in Medicine}, 28(4), 586-604.

Bretz, F., Posch, M., Glimm, E., Klinglmueller, F., Maurer, W., and
Rohmeyer, K. (2011). Graphical approaches for multiple comparison
procedures using weighted Bonferroni, Simes, or parametric tests.
\emph{Biometrical Journal}, 53(6), 894-913.
}
\seealso{
\itemize{
\item \code{\link[=graph_test_closure]{graph_test_closure()}} for graphical multiple comparison procedures using
the closed test,
\item \code{\link[=graph_rejection_orderings]{graph_rejection_orderings()}} for all possible rejection orderings.
}
}
