% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_treepcor.R
\name{cgeneric_treepcor}
\alias{cgeneric_treepcor}
\title{Build an \code{cgeneric} for \code{\link[=treepcor]{treepcor()}})}
\usage{
cgeneric_treepcor(
  graph,
  lambda,
  sigma.prior.reference,
  sigma.prior.probability,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{graph}{object of class \code{treepcor} for the model specification.}

\item{lambda}{the lambda parameter for the graph correlation prior.}

\item{sigma.prior.reference}{a vector with the reference values
to define the prior for the standard deviation parameters.}

\item{sigma.prior.probability}{a vector with the probability values
to define the prior for the standard deviation parameters.}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}
}
\value{
a \code{inla.cgeneric}, \code{\link[=cgeneric]{cgeneric()}} object.
}
\description{
This set the necessary data to implement the penalized
complexity prior for a correlation matrix considering
a three as proposed in
\href{https://arxiv.org/abs/2312.06289}{Sterrantino et. al. 2025}
}
\details{
The correlation prior as in the paper depends on the lambda value.
The prior for each \eqn{sigma_i} is the Penalized-complexity prior
which can be defined from the following probability statement
P(sigma > U) = a.
where "U" is a reference value and "a" is a probability.
The values "U" and probabilities "a" for each \eqn{sigma_i}
are passed in the \code{sigma.prior.reference} and \code{sigma.prior.probability}
arguments.
If a=0 then U is taken to be the fixed value of the corresponding sigma.
E.g. if there are three sigmas in the model and one supply
sigma.prior.reference = c(1, 2, 3) and
sigma.prior.probability = c(0.05, 0.0, 0.01)
then the sigma is fixed to 2 and not estimated.
}
\seealso{
\code{\link[=treepcor]{treepcor()}} and \code{\link[=cgeneric]{cgeneric()}}
}
