% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/kronecker.R,
%   R/rgeneric_utils.R
\docType{class}
\name{inla.rgeneric-class}
\alias{inla.rgeneric-class}
\alias{kronecker,inla.cgeneric,inla.rgeneric-method}
\alias{kronecker,inla.rgeneric,inla.cgeneric-method}
\alias{kronecker,inla.rgeneric,inla.rgeneric-method}
\alias{rgeneric}
\alias{rgeneric.default}
\alias{graph.inla.rgeneric}
\alias{prec.inla.rgeneric}
\alias{initial.inla.rgeneric}
\alias{mu.inla.rgeneric}
\alias{prior.inla.rgeneric}
\title{\code{inla.rgeneric} class, short \code{rgeneric},
to define a \code{\link[INLA:rgeneric]{INLA::rgeneric()}} latent model}
\usage{
\S4method{kronecker}{inla.cgeneric,inla.rgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{inla.rgeneric,inla.cgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{inla.rgeneric,inla.rgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

rgeneric(model, debug = FALSE, compile = TRUE, optimize = TRUE, ...)

\method{rgeneric}{default}(model, debug = FALSE, compile = TRUE, optimize = TRUE, ...)

\method{graph}{inla.rgeneric}(model, ...)

\method{prec}{inla.rgeneric}(model, ...)

\method{initial}{inla.rgeneric}(model)

\method{mu}{inla.rgeneric}(model, theta)

\method{prior}{inla.rgeneric}(model, theta)
}
\arguments{
\item{X}{\code{inla.cgeneric} or \code{inla.rgeneric}}

\item{Y}{\code{inla.cgeneric} or \code{inla.rgeneric}}

\item{FUN}{see \code{kronecker}}

\item{make.dimnames}{see \code{kronecker}}

\item{...}{additional parameter such as 'theta'
If 'theta' is not supplied, initial will be taken.}

\item{model}{a \code{inla.rgeneric} model object}

\item{debug}{logical indicating debug state.}

\item{compile}{logical indicating to compile the model.}

\item{optimize}{logical indicating if only the elements
of the precision matrix are returned.}

\item{theta}{the parameter.}
}
\value{
a \code{inla.rgeneric} object.
}
\description{
\code{inla.rgeneric} class, short \code{rgeneric},
to define a \code{\link[INLA:rgeneric]{INLA::rgeneric()}} latent model

Define rgeneric methods.

The rgeneric default method.
}
\section{Functions}{
\itemize{
\item \code{kronecker(X = inla.cgeneric, Y = inla.rgeneric)}: Kronecker (product) between a \code{inla.cgeneric} model and
a \code{inla.rgeneric} model as a method for kronecker()

\item \code{kronecker(X = inla.rgeneric, Y = inla.cgeneric)}: Kronecker (product) between a \code{inla.rgeneric} model and
a \code{inla.cgeneric} model as a method for kronecker()

\item \code{kronecker(X = inla.rgeneric, Y = inla.rgeneric)}: Kronecker (product) between a \code{inla.rgeneric} model and
a \code{inla.rgeneric} model as a method for kronecker()

\item \code{graph(inla.rgeneric)}: The graph method for 'inla.rgeneric'

\item \code{prec(inla.rgeneric)}: The precision method for an \code{inla.rgeneric} object.

\item \code{initial(inla.rgeneric)}: The initial method for 'inla.rgeneric'

\item \code{mu(inla.rgeneric)}: The mu method for 'inla.rgeneric'

\item \code{prior(inla.rgeneric)}: The prior metho for 'inla.rgeneric'

}}
