% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_Geometric_Asian_Greeks.R
\name{BS_Geometric_Asian_Greeks}
\alias{BS_Geometric_Asian_Greeks}
\title{Computes the Greeks of a Geometric Asian Option with classical Call- and
Put-Payoff in the Black Scholes model}
\usage{
BS_Geometric_Asian_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "rho", "vega", "theta", "gamma", "vomma")
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset, can also be a
vector
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item the payoff function, either a string in ("call", "put")
}}

\item{greek}{\itemize{
\item Greeks to be calculated in c("fair_value", "delta", "rho",
"vega", "theta", "gamma", "vomma")
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
For the definition of geometric Asian options see
\link{Malliavin_Geometric_Asian_Greeks}.
\link{BS_Geometric_Asian_Greeks} offers a fast and exaction computation of
Geometric Asian Greeks.
}
\examples{
BS_Geometric_Asian_Greeks(initial_price = 110, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "rho", "vega", "theta", "gamma"),
payoff = "put")

}
\seealso{
\link{Malliavin_Geometric_Asian_Greeks} for the Monte Carlo
implementation which provides digital and custom payoff functions and also
works for the jump diffusion model

\link{Greeks_UI} for an interactive visualization
}
