% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chm_analysis.R
\name{chm_analysis}
\alias{chm_analysis}
\title{Robust ALS GEDI CHM Analysis and Visualization}
\usage{
chm_analysis(
  location = NULL,
  bbox = NULL,
  aoi_geojson = NULL,
  chm_tif = NULL,
  output_dir = "chm_output",
  apply_mask = TRUE,
  crop_result = TRUE,
  create_plots = TRUE,
  height_threshold = 2,
  max_tiles = 100,
  mapview_html = "chm_mapview.html",
  tmap_png = "chm_tmap.png",
  max_cells_mapview = 2e+05,
  n_cores = parallel::detectCores() - 1,
  chunk_size = 5,
  cache_tiles = TRUE,
  compression = "LZW",
  user_agent_string = "R/chm_analysis_script (your_email_or_project_url)",
  request_timeout = 300
)
}
\arguments{
\item{location}{Character. Place name for AOI (e.g. "Basel, Switzerland").}

\item{bbox}{Numeric. Bounding box (xmin, ymin, xmax, ymax, EPSG:4326).}

\item{aoi_geojson}{Path to GeoJSON file defining AOI (overrides location/bbox).}

\item{chm_tif}{Path to a local CHM raster (.tif). If supplied, skips tile download/mosaic.}

\item{output_dir}{Output directory for all files.}

\item{apply_mask}{Mask raster to AOI (default TRUE).}

\item{crop_result}{Crop raster to AOI (default TRUE).}

\item{create_plots}{Export static tmap and histogram (default TRUE).}

\item{height_threshold}{Height (m) for tree coverage (default 2).}

\item{max_tiles}{Max CHM tiles to use (default 100).}

\item{mapview_html}{Output HTML file for interactive map.}

\item{tmap_png}{Output PNG for publication-quality map.}

\item{max_cells_mapview}{Maximum number of raster cells in the interactive map (default 1e5).}

\item{n_cores}{Parallel cores for download (default: parallel::detectCores() - 1).}

\item{chunk_size}{Tiles per parallel chunk (default 5).}

\item{cache_tiles}{Cache tiles/AOI (default TRUE).}

\item{compression}{Compression for output raster ("LZW", etc.).}

\item{user_agent_string}{HTTP user agent string (for Nominatim, etc).}

\item{request_timeout}{HTTP timeout in seconds (default 300).}
}
\value{
List with: raster, stats, static_map, mapview_file, plot_hist_file, tmap_file
}
\description{
\itemize{
\item \strong{Data Source:} ALS GEDI v6 global canopy height model, Meta & WRI (2024).
\item \strong{Interactive map is downsampled for browser performance}; see \code{max_cells_mapview}.
}
}
\details{
End-to-end or single-raster Canopy Height Model (CHM) analysis using
Meta & WRI's 1m ALS GEDI v6 global dataset. Downloads, mosaics,
crops, analyzes, and visualizes CHM data for any AOI, or analyzes a
user-supplied .tif directly. Outputs both publication-quality (tmap)
and interactive (mapview) maps, with progress/status reporting.

\strong{CRAN policy note:} This function downloads data from the internet if
\code{location}, \code{bbox}, or \code{aoi_geojson} are specified and the required local files
are not present. Internet access is not permitted in CRAN checks or
non-interactive sessions. If you are running in batch, automated, or non-interactive
mode (including CRAN), you \strong{must} provide all required files locally (e.g., \code{chm_tif}, \code{aoi_geojson}).
}
\examples{
\dontrun{
# Example 1: AOI from bounding box (Zurich, Switzerland)
res_bbox <- chm_analysis(
  bbox = c(8.51, 47.36, 8.56, 47.40),
  output_dir = tempdir(), max_tiles = 2, create_plots = TRUE
)
print(res_bbox$stats)

# Example 2: AOI from location string (Parc La Grange, Geneva)
res_loc <- chm_analysis(
  location = "Parc La Grange, Geneva, Switzerland",
  output_dir = tempdir(), max_tiles = 2
)
print(res_loc$stats)

# Example 3: Analyze a user-supplied CHM raster
# Assume you have a file "my_canopy.tif" (projected or WGS84)
res_tif <- chm_analysis(
  chm_tif = "my_canopy.tif",
  output_dir = tempdir(),
  create_plots = TRUE,
  height_threshold = 3
)
print(res_tif$stats)
}
}
