% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chol2inv_ii.R
\name{chol2inv_ii}
\alias{chol2inv_ii}
\title{Partial sparse matrix inverse from a Cholesky factorization.}
\usage{
chol2inv_ii(L, Z = NULL)
}
\arguments{
\item{L}{A lower-triangle Cholesky factorization ($\strong{L L'} = \strong{C}$).}

\item{Z}{A sparse matrix containing the partial inverse of $\strong{L L'}$
from a previous call to the function. Must contain the \dQuote{Zdiagp}
attribute.}
}
\value{
A sparse matrix containing the partial inverse of C ($\strong{L L'}$)
  along with attribute \dQuote{Zdiagp} indicating the location for diagonals
  of Z in \code{slot x} of the object \code{Z}.
}
\description{
Only calculate values of a sparse matrix inverse corresponding to non-zero
  locations for the Cholesky factorization.
}
\details{
If $\strong{L L'} = \strong{C}$, function efficiently gives diag(Cinv) by only
  calculating elements of Cinv based on non-zero elements of $\strong{L}$ and
  $\strong{L}$. Follows the method and equations by Takahashi et al. (1973).
}
\references{
Takahashi, Fagan, & Chin. 1973. Formation of a sparse bus impedance matrix
  and its application to short circuit study. 8th PICA Conference Proceedings,
  Minneapolis, MN.
}
\author{
\email{matthewwolak@gmail.com}
}
