% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{weighted_temperature_sum}
\alias{weighted_temperature_sum}
\title{Create a weighted temperature sum}
\usage{
weighted_temperature_sum(temperatures, negative = FALSE)
}
\arguments{
\item{temperatures}{vector Daily average temperatures in degree Celsius.}

\item{negative}{boolean Whether to include negative temperature values in 
the summation. By default, negative values are set to 0, meaning that 
the temperature sum is monotonically increasing.}
}
\value{
Weighted temperature sum.
}
\description{
A temperature sum is constructed by summing the average daily temperature 
for each day, but applying a weight factor of 0.5 for January and 0.75 for 
February.
}
\examples{
# Use fake temperatures
ts = rep(2, 365)
weighted_temperature_sum(ts)

}
