% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_design_ahr.R
\name{gs_design_ahr}
\alias{gs_design_ahr}
\title{Calculate sample size and bounds given targeted power and Type I error in group sequential design using average hazard ratio under non-proportional hazards}
\usage{
gs_design_ahr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  alpha = 0.025,
  beta = 0.1,
  info_frac = NULL,
  analysis_time = 36,
  ratio = 1,
  binding = FALSE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = alpha),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = beta),
  h1_spending = TRUE,
  test_upper = TRUE,
  test_lower = TRUE,
  info_scale = c("h0_h1_info", "h0_info", "h1_info"),
  r = 18,
  tol = 1e-06,
  interval = c(0.01, 1000)
)
}
\arguments{
\item{enroll_rate}{An \code{enroll_rate} data frame with or without stratum
created by \code{\link[=define_enroll_rate]{define_enroll_rate()}}.}

\item{fail_rate}{A \code{fail_rate} data frame with or without stratum
created by \code{\link[=define_fail_rate]{define_fail_rate()}}.}

\item{alpha}{One-sided Type I error.}

\item{beta}{Type II error.}

\item{info_frac}{Targeted information fraction for analyses. See details.}

\item{analysis_time}{Targeted calendar timing of analyses. See details.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{upper}{Function to compute upper bound.
\itemize{
\item \code{gs_spending_bound()}: alpha-spending efficacy bounds.
\item \code{gs_b()}: fixed efficacy bounds.
}}

\item{upar}{Parameters passed to \code{upper}.
\itemize{
\item If \code{upper = gs_b}, then \code{upar} is a numerical vector specifying the fixed efficacy bounds per analysis.
\item If \code{upper = gs_spending_bound}, then \code{upar} is a list including
\itemize{
\item \code{sf} for the spending function family.
\item \code{total_spend} for total alpha spend.
\item \code{param} for the parameter of the spending function.
\item \code{timing} specifies spending time if different from information-based spending; see details.
}
}}

\item{lower}{Function to compute lower bound, which can be set up similarly as \code{upper}.
See \href{https://merck.github.io/gsDesign2/articles/story-seven-test-types.html}{this vignette}.}

\item{lpar}{Parameters passed to \code{lower}, which can be set up similarly as \code{upar.}}

\item{h1_spending}{Indicator that lower bound to be set by spending
under alternate hypothesis (input \code{fail_rate})
if spending is used for lower bound.
If this is \code{FALSE}, then the lower bound spending is under the null hypothesis.
This is for two-sided symmetric or asymmetric testing under the null hypothesis;
See \href{https://merck.github.io/gsDesign2/articles/story-seven-test-types.html}{this vignette}.}

\item{test_upper}{Indicator of which analyses should include
an upper (efficacy) bound;
single value of \code{TRUE} (default) indicates all analyses; otherwise,
a logical vector of the same length as \code{info} should
indicate which analyses will have an efficacy bound.}

\item{test_lower}{Indicator of which analyses should include a lower bound;
single value of \code{TRUE} (default) indicates all analyses;
single value of \code{FALSE} indicated no lower bound; otherwise,
a logical vector of the same length as \code{info} should
indicate which analyses will have a lower bound.}

\item{info_scale}{Information scale for calculation. Options are:
\itemize{
\item \code{"h0_h1_info"} (default): variance under both null and alternative hypotheses is used.
\item \code{"h0_info"}: variance under null hypothesis is used.
This is often used for testing methods that use local alternatives, such as the Schoenfeld method.
\item \code{"h1_info"}: variance under alternative hypothesis is used.
}}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000); default is 18, range is 1 to 80.
Larger values provide larger number of grid points and greater accuracy.
Normally, \code{r} will not be changed by the user.}

\item{tol}{Tolerance parameter for boundary convergence (on Z-scale); normally not changed by the user.}

\item{interval}{An interval presumed to include the times at which
expected event count is equal to targeted event.
Normally, this can be ignored by the user as it is set to \code{c(.01, 1000)}.}
}
\value{
A list with input parameters, enrollment rate, analysis, and bound.
\itemize{
\item The \verb{$input} is a list including \code{alpha}, \code{beta}, \code{ratio}, etc.
\item The \verb{$enroll_rate} is a table showing the enrollment for arriving the targeted power (\code{1 - beta}).
\item The \verb{$fail_rate} is a table showing the failure and dropout rates, which is the same as input.
\item The \verb{$bound} is a table summarizing the efficacy and futility bound per analysis.
\item The \code{analysis} is a table summarizing the analysis time, sample size, events, average HR, treatment effect and statistical information per analysis.
}
}
\description{
Calculate sample size and bounds given targeted power and Type I error in group sequential design using average hazard ratio under non-proportional hazards
}
\details{
The parameters \code{info_frac} and \code{analysis_time} are used to determine the timing for interim and final analyses.
\itemize{
\item If the interim analysis is determined by targeted information fraction and the study duration is known,
then \code{info_frac} is a numerical vector where each element (greater than 0 and less than or equal to 1)
represents the information fraction for each analysis.
The \code{analysis_time}, which defaults to 36, indicates the time for the final analysis.
\item If interim analyses are determined solely by the targeted calendar analysis timing from start of study,
then \code{analysis_time} will be a vector specifying the time for each analysis.
\item If both the targeted analysis time and the targeted information fraction are utilized for a given analysis,
then timing will be the maximum of the two with both \code{info_frac} and \code{analysis_time} provided as vectors.
}
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input analysis_time is a positive number or positive
   increasing sequence.
   \item Validate if input info_frac is a positive number or positive
   increasing sequence
   on (0, 1] with final value of 1.
   \item Validate if input info_frac and analysis_time  have the same
   length if both have length > 1.
   \item Get information at input analysis_time
   \itemize{
     \item Use \code{gs_info_ahr()} to get the information and effect size
     based on AHR approximation.
     \item Extract the final event.
     \item Check if input If needed for (any) interim analysis timing.
   }
   \item Add the analysis column to the information at input analysis_time.
   \item Add the sample size column to the information at input analysis_time
   using \code{expected_accural()}.
   \item Get sample size and bounds using \code{gs_design_npe()} and
   save them to bounds.
   \item Add Time, Events, AHR, N that have already been calculated
   to the bounds.
   \item Return a list of design enrollment, failure rates, and bounds.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign)
library(gsDesign2)

# Example 1 ----
# call with defaults
gs_design_ahr()

# Example 2 ----
# Single analysis
gs_design_ahr(analysis_time = 40)

# Example 3 ----
# Multiple analysis_time
gs_design_ahr(analysis_time = c(12, 24, 36))

# Example 4 ----
# Specified information fraction
\donttest{
gs_design_ahr(info_frac = c(.25, .75, 1), analysis_time = 36)
}

# Example 5 ----
# multiple analysis times & info_frac
# driven by times
gs_design_ahr(info_frac = c(.25, .75, 1), analysis_time = c(12, 25, 36))
# driven by info_frac
\donttest{
gs_design_ahr(info_frac = c(1 / 3, .8, 1), analysis_time = c(12, 25, 36))
}

# Example 6 ----
# 2-sided symmetric design with O'Brien-Fleming spending
\donttest{
gs_design_ahr(
  analysis_time = c(12, 24, 36),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  h1_spending = FALSE
)
}
# 2-sided asymmetric design with O'Brien-Fleming upper spending
# Pocock lower spending under H1 (NPH)
\donttest{
gs_design_ahr(
  analysis_time = c(12, 24, 36),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDPocock, total_spend = 0.1, param = NULL, timing = NULL),
  h1_spending = TRUE
)
}

# Example 7 ----
\donttest{
gs_design_ahr(
  alpha = 0.0125,
  analysis_time = c(12, 24, 36),
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.0125, param = NULL, timing = NULL),
  lower = gs_b,
  lpar = rep(-Inf, 3)
)

gs_design_ahr(
  alpha = 0.0125,
  analysis_time = c(12, 24, 36),
  upper = gs_b,
  upar = gsDesign::gsDesign(
    k = 3, test.type = 1, n.I = c(.25, .75, 1),
    sfu = sfLDOF, sfupar = NULL, alpha = 0.0125
  )$upper$bound,
  lower = gs_b,
  lpar = rep(-Inf, 3)
)
}
}
