% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments2markers.R
\name{segments2markers}
\alias{segments2markers}
\title{Map alleles from scrambled founders to the sampled segments from a GSP.}
\usage{
segments2markers(
  Segs,
  Im,
  Mm,
  G,
  preserve_haplotypes = FALSE,
  preserve_individuals = FALSE
)
}
\arguments{
\item{Segs}{the simulated segments. A tibble like that returned from
\code{\link[=segregate]{segregate()}}.}

\item{Im}{the individual meta data, like that in \code{\link{I_meta}}. A tibble with
columns \code{group} and \code{indiv}.}

\item{Mm}{the marker meta data formatted like that in \code{\link{M_meta}}. A tibble
with columns \code{chrom}, \code{pos}, and \code{variant_id}.}

\item{G}{the marker genotype data as a matrix like \code{\link{Geno}}.  This is
a character matrix.  Each row is an individual, and each pair of columns are the
alleles at a locus.  Thus it is N x 2L where N is the number of individuals
and L is the number of markers.}

\item{preserve_haplotypes}{If TRUE then the Geno data is assumed phased
(first allele at an individual on one haplotype and second allele on the
other) and those haplotypes are preserved in this permutation of
genomic material amongst the founders.}

\item{preserve_individuals}{If TRUE then whole individuals are permuted
around the data set and the two gene copies at each locus are randomly
permuted within each individual.  If \code{preserve_individuals = "BY_CHROM"},
then the the two copies of each chromosome in an individual are permuted
together.  Thus a permuted individual may have two copies of one chromosome
from one individual, and two copies of another chromosome from a different
individual.  (If \code{preserve_haplotypes = TRUE} then
the gene copies are not permuted within individuals. You should only ever
use \code{preserve_haplotypes = TRUE} if you have phased data.)}
}
\value{
A list with three components:
\itemize{
\item \code{ret_geno}: A character matrix where each row is an individual and each pair of
columns are the alleles at a locus, thus it is N x 2L where N is the number of
individuals and L is the number of markers.
\item \code{ret_ids}: A tibble providing the individual meta data with columns \code{groups} and \code{indiv}.
\item \code{hyb_Qs}: A tibble of the admixture Q values.
}
}
\description{
Map alleles from scrambled founders to the sampled segments from a GSP.
}
\examples{
#### First, get input segments for the function ####
# We construct an example here where we will request segregation
# down a GSP with two F1s and F1B backcrosses between two hypothetical
# populations, A and B.
set.seed(5)
gsp_f1f1b <- create_GSP("A", "B", F1 = TRUE, F1B = TRUE)

# We will imagine that in our marker data there are three groups
# labelled "Pop1", "Pop2", and "Pop3", and we want to create the F1Bs with backcrossing
# only to Pop3.
reppop <- tibble::tibble(
    index = as.integer(c(1, 1, 2, 2)),
    pop = c("A", "B", "A", "B"),
    group = c("Pop3", "Pop1", "Pop3", "Pop2")
)

# combine those into a request
request <- tibble::tibble(
   gpp = list(gsp_f1f1b),
   reppop = list(reppop)
)

# now segegate segments.  Explicitly pass the markers
# in M_meta so that the order of the markers is set efficiently.
segs <- segregate(request, RecRates, M_meta)

#### Now, use segs in an example with segments2markers() ####
# this uses several package data objects that are there for examples
# and illustration.
s2m_result <- segments2markers(segs, I_meta, M_meta, Geno)
}
