% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_graphTable.R
\name{bench_graphs}
\alias{bench_graphs}
\alias{ori_plot}
\alias{adj_plot}
\alias{GR_plot}
\alias{GR_table}
\title{Generate a benchmarking graphic}
\usage{
ori_plot(
  graphTable,
  title_str = "Original Scale",
  subtitle_str = NULL,
  mth_gap = NULL,
  points_set = NULL,
  pt_sz = 2,
  display_ggplot = TRUE,
  .setup = TRUE
)

adj_plot(
  graphTable,
  title_str = "Adjustment Scale",
  subtitle_str = NULL,
  mth_gap = NULL,
  full_set = NULL,
  pt_sz = 2,
  display_ggplot = TRUE,
  .setup = TRUE
)

GR_plot(
  graphTable,
  title_str = "Growth Rates",
  subtitle_str = NULL,
  factor = NULL,
  type_chars = NULL,
  periodicity = NULL,
  display_ggplot = TRUE,
  .setup = TRUE
)

GR_table(
  graphTable,
  title_str = "Growth Rates Table",
  subtitle_str = NULL,
  factor = NULL,
  type_chars = NULL,
  display_ggplot = TRUE,
  .setup = TRUE
)
}
\arguments{
\item{graphTable}{(mandatory)

Data frame (object of class "data.frame") corresponding to the benchmarking function output\code{graphTable} data frame.}

\item{title_str, subtitle_str}{(optional)

Graphic title and subtitle strings (character constants). \code{subtitle_str} is automatically built from the
\code{graphTable} data frame contents when \code{NULL} and contains the \code{graphTable} data frame name on the 2\if{html}{\out{<sup>}}nd\if{html}{\out{</sup>}} line
and the benchmarking parameters on the 3\if{html}{\out{<sup>}}rd\if{html}{\out{</sup>}} line. Specifying empty strings (\code{""}) would remove the titles.
Simple Markdown and HTML syntax is allowed (e.g., for bold, italic or colored fonts) through package \link[ggtext:ggtext]{ggtext}
(see \code{help(package = "ggtext")}).

\strong{Default values} are \code{subtitle_str = NULL} and a function specific string for \code{title_str} (see \strong{Usage}).}

\item{mth_gap}{(optional)

Number of months between consecutive periods (e.g. 1 for monthly data, 3 for quarterly data, etc.). Based
on the \code{graphTable} data frame contents  when \code{NULL} (calculated as \code{12 / graphTable$periodicity[1]}).

\strong{Default value} is \code{mth_gap = NULL}.}

\item{points_set, full_set}{(optional)

Character vector of the elements (variables of the \code{graphTable} data frame) to include in the plot.
Automatically built when \code{NULL}. See \code{\link[=plot_graphTable]{plot_graphTable()}} for the (default) list of variables used for each
type of graphic.

\strong{Default values} are \code{points_set = NULL} and \code{full_set = NULL}.}

\item{pt_sz}{(optional)

Size of the data points shape (symbol) for ggplot2.

\strong{Default value} is \code{pt_sz = 2}.}

\item{display_ggplot}{(optional)

Logical arguments indicating whether or not the ggplot object(s) should be displayed in the current (active)
graphics device.

\strong{Default value} is \code{display_ggplot = TRUE}.}

\item{.setup}{(optional)

Logical argument indicating whether the setup steps must be executed or not. Must be \code{TRUE} when the function
is called directly (i.e., outside of the \code{\link[=plot_graphTable]{plot_graphTable()}} context).

\strong{Default value} is \code{.setup = TRUE}.}

\item{factor, type_chars}{(optional)

Growth rates factor (1 or 100) and value label suffix ("" or "(\%)") according to the adjustment model parameter
\eqn{\lambda}. Based on the \code{graphTable} data frame contents when \code{NULL} (based on \code{graphTable$lambda[1]}).

\strong{Default values} are \code{factor = NULL} and \code{type_chars = NULL}.}

\item{periodicity}{(optional)

Number of periods in a year. Based on the \code{graphTable} data frame contents when \code{NULL} (defined as
\code{graphTable$periodicity[1]}).

\strong{Default value} is \code{periodicity = NULL}.}
}
\value{
In addition to displaying the corresponding graphic(s) in the current (active) graphics device (except when
\code{display_ggplot = FALSE}), each function also invisibly returns a list containing the generated ggplot object(s).
Notes:
\itemize{
\item \code{\link[=ori_plot]{ori_plot()}} and \code{\link[=adj_plot]{adj_plot()}} generate a single ggplot object (single graphic) while \code{\link[=GR_plot]{GR_plot()}} and \code{\link[=GR_table]{GR_table()}}
will often generate several ggplot objects (several graphics).
\item The returned ggplot object(s) can be displayed \emph{manually} with \code{\link[=print]{print()}}, in which case the following ggplot2 theme
updates (used internally when \code{display_ggplot = TRUE}) are suggested:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{ggplot2::theme_update(
  plot.title = ggtext::element_markdown(hjust = 0.5),
  plot.subtitle = ggtext::element_markdown(hjust = 0.5),
  legend.position = "bottom",
  plot.margin = ggplot2::margin(t = 1.5, r = 1.5, b = 1.5, l = 1.5, unit = "cm"))
}\if{html}{\out{</div>}}
}
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/bench_graphs.html}})}

Functions used internally by \code{\link[=plot_graphTable]{plot_graphTable()}} to generate the benchmarking graphics in a PDF file:
\itemize{
\item \code{\link[=ori_plot]{ori_plot()}}: Original Scale Plot (\code{\link[=plot_graphTable]{plot_graphTable()}} argument \code{ori_plot_flag = TRUE})
\item \code{\link[=adj_plot]{adj_plot()}}: Adjustment Scale Plot (\code{\link[=plot_graphTable]{plot_graphTable()}} argument \code{adj_plot_flag = TRUE})
\item \code{\link[=GR_plot]{GR_plot()}}: Growth Rates Plot (\code{\link[=plot_graphTable]{plot_graphTable()}} argument \code{GR_plot_flag = TRUE})
\item \code{\link[=GR_table]{GR_table()}}: Growth Rates Table (\code{\link[=plot_graphTable]{plot_graphTable()}} argument \code{GR_table_flag = TRUE})
}

When these functions are called directly, the \code{graphTable} data frame should only  contain a \strong{single series}
and the graphic is generated in the current (active) graphics device.
}
\details{
See \code{\link[=plot_graphTable]{plot_graphTable()}} for a detailed description of the four benchmarking graphics associated to these
individual functions. These graphics are optimized for the US Letter paper size format in landscape view, i.e.,
11in wide (27.9cm, 1056px with 96 DPI) and 8.5in tall (21.6cm, 816px with 96 DPI). Keep this in mind when
viewing or saving graphics generated by calls to these individual functions (i.e., outside of the \code{\link[=plot_graphTable]{plot_graphTable()}}
context). Also note that \code{\link[=GR_plot]{GR_plot()}} and \code{\link[=GR_table]{GR_table()}} will often generate more than one graphic (more than one
\emph{page}), unless the number of periods included in the input \code{graphTable} data frame is reduced (e.g., subsetting
the data frame by ranges of calendar years).
}
\examples{
# Deactivate the graphics device creation for the pkgdown website HTML reference page
# (irrelevant in that context)
new_grDev <- !(identical(Sys.getenv("IN_PKGDOWN"), "true"))


# Initial quarterly time series (indicator series to be benchmarked)
qtr_ts <- ts(c(1.9, 2.4, 3.1, 2.2, 2.0, 2.6, 3.4, 2.4, 2.3),
             start = c(2015, 1), frequency = 4)

# Annual time series (benchmarks)
ann_ts <- ts(c(10.3, 10.2), start = 2015, frequency = 1)

# Proportional benchmarking
out_bench <- benchmarking(ts_to_tsDF(qtr_ts),
                          ts_to_bmkDF(ann_ts, ind_frequency = 4),
                          rho = 0.729, lambda = 1, biasOption = 3,
                          quiet = TRUE)


# Open a new graphics device that is 11in wide and 8.5in tall 
# (US Letter paper size format in landscape view)
if (new_grDev) {
  dev.new(width = 11, height = 8.5, unit = "in", noRStudioGD = TRUE)
}

# Generate the benchmarking graphics
ori_plot(out_bench$graphTable)
adj_plot(out_bench$graphTable)
GR_plot(out_bench$graphTable)
GR_table(out_bench$graphTable)


# Simulate multiple series benchmarking (3 series)

qtr_mts <- ts.union(ser1 = qtr_ts, ser2 = qtr_ts * 100, ser3 = qtr_ts * 10)
ann_mts <- ts.union(ser1 = ann_ts, ser2 = ann_ts * 100, ser3 = ann_ts * 10)

# Using argument `allCols = TRUE` (identify series with column `varSeries`)
out_bench2 <- benchmarking(ts_to_tsDF(qtr_mts),
                           ts_to_bmkDF(ann_mts, ind_frequency = 4),
                           rho = 0.729, lambda = 1, biasOption = 3,
                           allCols = TRUE,
                           quiet = TRUE)

# Original and adjustment scale plots for the 2nd series (ser2)
ser2_res <- out_bench2$graphTable[out_bench2$graphTable$varSeries == "ser2", ]
ori_plot(ser2_res)
adj_plot(ser2_res)

# Using argument `by = "series"` (identify series with column `series`)
out_bench3 <- benchmarking(stack_tsDF(ts_to_tsDF(qtr_mts)),
                           stack_bmkDF(ts_to_bmkDF(ann_mts, ind_frequency = 4)),
                           rho = 0.729, lambda = 1, biasOption = 3,
                           by = "series",
                           quiet = TRUE)
						   
# Growth rates plot for the 3rd series (ser3)
ser3_res <- out_bench3$graphTable[out_bench3$graphTable$series == "ser3", ]
GR_plot(ser3_res)


# Close the graphics device 
if (new_grDev) {
  dev.off()
}
}
\seealso{
\code{\link[=plot_graphTable]{plot_graphTable()}} \code{\link[=plot_benchAdj]{plot_benchAdj()}} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
