% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_tsDF.R
\name{stack_tsDF}
\alias{stack_tsDF}
\title{Stack time series data}
\usage{
stack_tsDF(
  ts_df,
  ser_cName = "series",
  yr_cName = "year",
  per_cName = "period",
  val_cName = "value",
  keep_NA = FALSE
)
}
\arguments{
\item{ts_df}{(mandatory)

Data frame (object of class "data.frame") that contains the multivariate time series data to be stacked.}

\item{ser_cName}{(optional)

String specifying the name of the character variable (column) in the output stacked data frame that will
contain the series names (name of the time series variables in the input multivariate time series data
frame). This variable can then be used as the BY-group variable (argument \code{by}) with the benchmarking functions.

\strong{Default value} is \code{ser_cName = "series"}.}

\item{yr_cName, per_cName}{(optional)

Strings specifying the name of the numeric variables (columns) in the input multivariate time series data frame
that contain the data point year and period (cycle) identifiers. These variables are \emph{transferred} to the output
stacked data frame with the same variable names.

\strong{Default values} are \code{yr_cName = "year"} and \code{per_cName   = "period"}.}

\item{val_cName}{(optional)

String specifying the name of the numeric variable (column) in the output stacked data frame that will
contain the data point values.

\strong{Default value} is \code{val_cName = "value"}.}

\item{keep_NA}{(optional)

Logical argument specifying whether \code{NA} time series values in the input multivariate time series data frame
should be kept in the output stacked data frame.

\strong{Default value} is \code{keep_NA = FALSE}.}
}
\value{
The function returns a data frame with four variables:
\itemize{
\item Series name, type character (see argument \code{ser_cName})
\item Data point year, type numeric (see argument \code{yr_cName})
\item Data point period, type numeric (see argument \code{per_cName})
\item Data point value, type numeric (see argument \code{val_cName})
}

Note: the function returns a "data.frame" object than can be explicitly coerced to another type of object
with the appropriate \verb{as*()} function (e.g., \code{tibble::as_tibble()} would coerce it to a tibble).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/stack_tsDF.html}})}

Convert a multivariate time series data frame (see \code{\link[=ts_to_tsDF]{ts_to_tsDF()}}) for the benchmarking functions
(\code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}}) into a stacked (tall) data frame with four variables (columns):
\itemize{
\item one (1) for the series name
\item two (2) for the data point identification (year and period)
\item one (1) for the data point value
}

Missing (\code{NA}) series values are not included in the output stacked data frame by default. Specify argument
\code{keep_NA = TRUE} in order to keep them.

This function is useful when intending to use the \code{by} argument (\emph{BY-group} processing mode) of the benchmarking
functions in order to benchmark multiple series in a single function call.
}
\examples{
# Create a data frame with 2 quarterly indicators series
# (with missing values for the last 2 quarters)
my_indicators <- ts_to_tsDF(ts(data.frame(ser1 = c(1:5 *  10, NA, NA),
                                          ser2 = c(1:5 * 100, NA, NA)), 
                               start = c(2019, 1), frequency = 4))
my_indicators


# Stack the indicator series ...

# discarding `NA` values in the output stacked data frame (default behavior)
stack_tsDF(my_indicators)

# keeping `NA` values in the output stacked data frame
stack_tsDF(my_indicators, keep_NA = TRUE)

# using custom variable (column) names
stack_tsDF(my_indicators, ser_cName = "ser_name", val_cName = "ser_val")
}
\seealso{
\code{\link[=unstack_tsDF]{unstack_tsDF()}} \code{\link[=stack_bmkDF]{stack_bmkDF()}} \code{\link[=ts_to_tsDF]{ts_to_tsDF()}} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
