% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsDF_to_ts.R
\name{tsDF_to_ts}
\alias{tsDF_to_ts}
\title{Reciprocal function of \code{\link[=ts_to_tsDF]{ts_to_tsDF()}}}
\usage{
tsDF_to_ts(
  ts_df,
  frequency,
  yr_cName = "year",
  per_cName = "period"
)
}
\arguments{
\item{ts_df}{(mandatory)

Data frame (object of class "data.frame") to be converted.}

\item{frequency}{(mandatory)

Integer specifying the frequency of the time series to be converted. The frequency of a time series corresponds
to the maximum number of periods in a year (12 for a monthly data, 4 for a quarterly data, 1 for annual data).}

\item{yr_cName, per_cName}{(optional)

Strings specifying the name of the numeric variables (columns) in the input data frame that contain the data
point year and period identifiers.

\strong{Default values} are \code{yr_cName = "year"} and \code{per_cName   = "period"}.}
}
\value{
The function returns a time series object (class "ts" or "mts"), which can be explicitly coerced to another type
of object with the appropriate \verb{as*()} function (e.g., \code{tsibble::as_tsibble()} would coerce it to a tsibble).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/tsDF_to_ts.html}})}

Convert a (non-stacked) time series data frame (\code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}} data format)
into a "ts" (or "mts") object.

This function is useful to convert the benchmarked data frame returned by a call to \code{\link[=benchmarking]{benchmarking()}} or
\code{\link[=stock_benchmarking]{stock_benchmarking()}} into a "ts" object, where one or several series were benchmarked in \emph{non BY-group}
processing mode. Stacked time series data frames associated to executions in \emph{BY-group} mode must first be
\emph{unstacked} with \code{\link[=unstack_tsDF]{unstack_tsDF()}}.
}
\examples{
# Initial quarterly time series (indicator series to be benchmarked)
qtr_ts <- ts(c(1.9, 2.4, 3.1, 2.2, 2.0, 2.6, 3.4, 2.4, 2.3),
             start = c(2015, 1), frequency = 4)

# Annual time series (benchmarks)
ann_ts <- ts(c(10.3, 10.2), start = 2015, frequency = 1)


# Proportional benchmarking
out_bench <- benchmarking(ts_to_tsDF(qtr_ts),
                          ts_to_bmkDF(ann_ts, ind_frequency = 4),
                          rho = 0.729, lambda = 1, biasOption = 3,
                          quiet = TRUE)

# Initial and final (benchmarked) quarterly time series ("ts" objects)
qtr_ts
tsDF_to_ts(out_bench$series, frequency = 4)


# Proportional end-of-year stock benchmarking - multiple (3) series processed 
# with argument `by` (in BY-group mode)
qtr_mts <- ts.union(ser1 = qtr_ts,     ser2 = qtr_ts * 100, ser3 = qtr_ts * 10)
ann_mts <- ts.union(ser1 = ann_ts / 4, ser2 = ann_ts * 25,  ser3 = ann_ts * 2.5)
out_bench2 <- stock_benchmarking(stack_tsDF(ts_to_tsDF(qtr_mts)),
                                 stack_bmkDF(ts_to_bmkDF(
                                   ann_mts, ind_frequency = 4,
                                   discrete_flag = TRUE, alignment = "e")),
                                 rho = 0.729, lambda = 1, biasOption = 3,
                                 by = "series",
                                 quiet = TRUE)

# Initial and final (benchmarked) quarterly time series ("mts" objects)
qtr_mts
tsDF_to_ts(unstack_tsDF(out_bench2$series), frequency = 4)
}
\seealso{
\code{\link[=ts_to_tsDF]{ts_to_tsDF()}} \code{\link[=unstack_tsDF]{unstack_tsDF()}} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
