% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstack_tsDF.R
\name{unstack_tsDF}
\alias{unstack_tsDF}
\title{Reciprocal function of \code{\link[=stack_tsDF]{stack_tsDF()}}}
\usage{
unstack_tsDF(
  ts_df,
  ser_cName = "series",
  yr_cName = "year",
  per_cName = "period",
  val_cName = "value"
)
}
\arguments{
\item{ts_df}{(mandatory)

Data frame (object of class "data.frame") that contains the multivariate time series data to be \emph{unstacked}.}

\item{ser_cName}{(optional)

String specifying the name of the character variable (column) in the input time series data frame that
contains the series identifier (the time series variable names in the output data frame).

\strong{Default value} is \code{ser_cName = "series"}.}

\item{yr_cName, per_cName}{(optional)

Strings specifying the name of the numeric variables (columns) in the input time series data frame that
contain the data point year and period identifiers. These variables are \emph{transferred} to the output data
frame with the same names.

\strong{Default values} are \code{yr_cName = "year"} and \code{per_cName   = "period"}.}

\item{val_cName}{(optional)

String specifying the name of the numeric variable (column) in the input time series data frame that
contains the data point values.

\strong{Default value} is \code{val_cName = "value"}.}
}
\value{
The function returns a data frame with three or more variables:
\itemize{
\item Data point year, type numeric (see argument \code{yr_cName})
\item Data point period, type numeric (see argument \code{per_cName})
\item One time series data variable for each distinct value of the input data frame variable specified with
argument \code{ser_cName}, type numeric (see arguments \code{ser_cName} and \code{val_cName})
}

Note: the function returns a "data.frame" object than can be explicitly coerced to another type of object
with the appropriate \verb{as*()} function (e.g., \code{tibble::as_tibble()} would coerce it to a tibble).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/unstack_tsDF.html}})}

Convert a stacked (tall) multivariate time series data frame (\code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}}
data format) into a non-stacked (wide) multivariate time series data frame.

This function, combined with \code{\link[=tsDF_to_ts]{tsDF_to_ts()}}, is useful to convert the benchmarked data frame returned by a call to
\code{\link[=benchmarking]{benchmarking()}} or \code{\link[=stock_benchmarking]{stock_benchmarking()}} back into a "mts" object, where multiple series were benchmarked in
\emph{BY-group} processing mode.
}
\examples{
# Proportional benchmarking for multiple (3) quarterly series processed with 
# argument `by` (in BY-group mode)

ind_vec <- c(1.9, 2.4, 3.1, 2.2, 2.0, 2.6, 3.4, 2.4, 2.3)
ind_df <- ts_to_tsDF(ts(data.frame(ser1 = ind_vec,
                                   ser2 = ind_vec * 100,
                                   ser3 = ind_vec * 10),
                        start = c(2015, 1), frequency = 4))

bmk_vec <- c(10.3, 10.2)
bmk_df <- ts_to_bmkDF(ts(data.frame(ser1 = bmk_vec,
                                    ser2 = bmk_vec * 100,
                                    ser3 = bmk_vec * 10), 
                         start = 2015, frequency = 1),
                      ind_frequency = 4)

out_bench <- benchmarking(stack_tsDF(ind_df),
                          stack_bmkDF(bmk_df),
                          rho = 0.729, lambda = 1, biasOption = 3,
                          by = "series",
                          quiet = TRUE)

# Initial and final (benchmarked) quarterly time series data frames
ind_df
unstack_tsDF(out_bench$series)
}
\seealso{
\code{\link[=stack_tsDF]{stack_tsDF()}} \code{\link[=tsDF_to_ts]{tsDF_to_ts()}} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
