% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_stub_summary}
\alias{cells_stub_summary}
\title{Location helper for targeting the stub cells in a summary}
\usage{
cells_stub_summary(groups = everything(), rows = everything())
}
\arguments{
\item{groups}{\emph{Specification of row group IDs}

\verb{<row-group-targeting expression>} // \emph{default:} \code{everything()}

The row groups to which targeting operations are constrained. Can either be
a series of row group ID values provided in \code{c()} or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{groups}, we can specify which of their rows should
form a constraint for targeting operations. The default \code{\link[=everything]{everything()}}
results in all rows in \code{columns} being formatted. Alternatively, we can
supply a vector of row IDs within \code{c()}, a vector of row indices, or a
select helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}},
\code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use
expressions to filter down to the rows we need
(e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}
}
\value{
A list object with the classes \code{cells_stub_summary} and
\code{location_cells}.
}
\description{
\code{cells_stub_summary()} is used to target the stub cells of
summary and it is useful when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or
adding custom styles with \code{\link[=tab_style]{tab_style()}}. The function is expressly used in
each of those functions' \code{locations} argument. The 'stub_summary' location is
generated by \code{\link[=summary_rows]{summary_rows()}}.
}
\section{Targeting summary stub cells with \code{groups} and \code{rows}}{


Targeting the stub cells of group summary rows is done through the \code{groups}
and \code{rows} arguments. By default \code{groups} is set to \code{everything()}, which means
that all available groups will be considered. Providing the ID values (in
quotes) of row groups in \code{c()} will serve to constrain the targeting to that
subset of groups.

Once the groups are targeted, we may also target the \code{rows} of the summary.
Summary cells in the stub will have ID values that can be used much like
column names in the \code{columns}-targeting scenario. We can use simpler
\strong{tidyselect}-style expressions (the select helpers should work well here)
and we can use quoted row identifiers in \code{c()}. It's also possible to use row
indices (e.g., \code{c(3, 5, 6)}) that correspond to the row number of a summary
row in a row group (numbering restarts with every row group).
}

\section{Examples}{


Use a portion of the \code{\link{countrypops}} dataset to create a \strong{gt} table. Add
some styling to the summary data stub cells with \code{\link[=tab_style]{tab_style()}} and
\code{cells_stub_summary()} in the \code{locations} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::filter(country_name == "Japan", year < 1970) |>
  dplyr::select(-contains("country")) |>
  dplyr::mutate(decade = paste0(substr(year, 1, 3), "0s")) |>
  gt(
    rowname_col = "year",
    groupname_col = "decade"
  ) |>
  fmt_integer(columns = population) |>
  summary_rows(
    groups = "1960s",
    columns = population,
    fns = list("min", "max"),
    fmt = ~ fmt_integer(.)
  ) |>
  tab_style(
    style = list(
      cell_text(
        weight = "bold",
        transform = "capitalize"
      ),
      cell_fill(
        color = "lightblue",
        alpha = 0.5
      )
    ),
    locations = cells_stub_summary(
      groups = "1960s"
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_stub_summary_1.png" alt="This image of a table was generated from the first code example in the `cells_stub_summary()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-21
}

\section{Function Introduced}{

\code{v0.3.0} (May 12, 2021)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
