% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subject.R
\name{get_subject}
\alias{get_subject}
\title{Get Subject}
\usage{
get_subject(
  datasetId = "gtex_v8",
  sex = NULL,
  ageBrackets = NULL,
  hardyScale = NULL,
  subjectIds = NULL,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{sex}{String. Options: "male", "female".}

\item{ageBrackets}{The age bracket(s) of the donors of interest. Options:
"20-29", "30-39", "40-49", "50-59", "60-69", "70-79".}

\item{hardyScale}{String A Hardy Scale of interest.
Options: "Ventilator case", "Fast death - violent", "Fast death - natural
causes", "Intermediate death", "Slow death".}

\item{subjectIds}{Character vector. GTEx subject ID.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
This service returns information of subjects used in analyses
from all datasets. Results may be filtered by dataset ID, subject ID, sex,
age bracket or Hardy Scale. By default, this service queries the latest GTEx
release.

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_subject_api_v2_dataset_subject_get}{GTEx Portal API documentation}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_subject()
\dontshow{\}) # examplesIf}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
