% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{energy}
\alias{energy}
\alias{energy.default}
\alias{energy.matrix}
\alias{energy.FitLandDF}
\title{Energy Metric for a GLCM}
\usage{
energy(x, ...)

\method{energy}{default}(x, ...)

\method{energy}{matrix}(x, ...)

\method{energy}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the energy feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate energy of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate energy
energy(n_x)

## calculate energy of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate energy of fitness landscape, assuming 2 discrete gray levels
energy(my_landscape, nlevels = 2)

## confirm value of energy for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate energy of extracted GLCM
energy(my_glcm)  # should match value of above energy function call
}
