% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ef_europe_emep_db}
\alias{ef_europe_emep_db}
\title{Emission factors from European Environment Agency — EMEP/EEA}
\format{
A data.table with 6431 rows and 22 variables:
\describe{
\item{Category}{Buses.}
\item{Fuel}{Fuel type, classified in "D" (Diesel),"DHD" (Diesel Hybrid ~ Diesel),
"DHE" (Diesel Hybrid ~ Electricity), "CNG" (Compressed Natural Gas), "BD" (Biodiesel). }
\item{Segment}{character; Bus type, classified in "Ubus Midi <=15 t","Ubus Std 15 - 18 t","Ubus Artic >18 t",
"Coaches Std <=18 t","Coaches Artic >18 t".}
\item{Euro}{character; Euro period of vehicle, classified in "Conventional", "I", "II", "III", "IV", "V", "VI", and "EEV".}
\item{Technology}{character; After treatment technology, classified in "SCR" (Selective Catalytic Reduction),
"EGR" (Exhaust Gas Recirculation), and "DPF+SCR" (Diesel Particulate Filter + SCR, for Euro VI). Default is "SCR" for "IV" and "V". There are
no available after treatment technology associated with euro standards "Conventional", "I", "II" and "III". }
\item{Pol}{character; Pollutant, classified in "FC","CO2","CO","NOx","VOC","PM10","EC","CH4","NH3","N2O". "FC" means Fuel Consumption. }
\item{Vmin}{Minimum speed for emission factor estimation, in km/h.}
\item{Vmax}{Maximum speed for emission factor estimation, in km/h.}
\item{Alpha, Beta, Gamma, Delta, Epsilon, Zita, Hta, Thita}{Constant parameters.}
\item{RF}{Reduction Factor; In percentage (\%) units.}
\item{k}{Constant factor.}
}
}
\source{
More information can be found at
\url{https://www.eea.europa.eu//publications/emep-eea-guidebook-2019},
\url{https://www.eea.europa.eu/publications/emep-eea-guidebook-2016/},
\url{https://www.eea.europa.eu/publications/emep-eea-guidebook-2013/}, and
\url{https://www.eea.europa.eu/publications/EMEPCORINAIR5/}.
}
\usage{
ef_europe_emep_db
}
\description{
Hot exhaust emission factors are speed dependent functions and are expressed in g/km.
It varies by fuel, vehicle segment, euro standard, pollutant, and after treatment technology.
These variables are consolidated in different EF equations, given by:
}
\details{
EF = EF(Alpha, Beta, Gamma, Delta, Epsilon, Zita, Hta, RF, Speed, Function_ID, k, fcorr),

where Alpha, Beta, Gamma, Delta, Epsilon, Zeta, Eta are constant parameters;
RF is the Reduction Factor, Speed in the average speed, Function_ID is the
equation (function of on the year of the inventory and the pollutant); k is
a constant value, and fcorr is the fuel correction factor.

The emissions factors are derived from the EMEP/EEA air pollutant emission inventory guidebook
(formerly called the EMEP CORINAIR emission inventory guidebook). The document provides guidance on
estimating emissions from both anthropogenic and natural emission sources.

The package presents a combination of emission factors from EMEP/EEA guidelines of 2007,
2013, 2016, and 2019, aiming to cover a greater number of pollutants and vehicle segments.
The script used to process the raw EMEP/EEA databases can be found in the repository
<\url{https://github.com/ipeaGIT/gtfs2emis/blob/master/data-raw/ef_europe_emep_db.R}>.
}
\seealso{
Other emission factor data: 
\code{\link{ef_brazil_cetesb_db}},
\code{\link{ef_usa_emfac_db}},
\code{\link{ef_usa_moves_db}}
}
\concept{emission factor data}
\keyword{datasets}
