% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trip_duration.R
\name{get_trip_duration}
\alias{get_trip_duration}
\title{Get trip duration}
\usage{
get_trip_duration(gtfs, trip_id = NULL, unit = "min")
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A string vector including the \code{trip_id}s to have their
duration calculated. If \code{NULL} (the default) the function calculates the
duration of every \code{trip_id} in the GTFS.}

\item{unit}{A string representing the time unit in which the duration is
desired. One of \code{"s"} (seconds), \code{"min"} (minutes, the default), \code{"h"}
(hours) or \code{"d"} (days).}
}
\value{
A \code{data.table} containing the duration of each specified trip.
}
\description{
Returns the duration of each specified \code{trip_id}.
}
\section{Details}{

The duration of a trip is defined as the time difference between its last
arrival time and its first departure time, as specified in the \code{stop_times}
table.
}

\examples{
\dontshow{
  old_dt_threads <- data.table::setDTthreads(1)
  on.exit(data.table::setDTthreads(old_dt_threads), add = TRUE)
}
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

trip_duration <- get_trip_duration(gtfs)
head(trip_duration)

trip_ids <- c("CPTM L07-0", "2002-10-0")
trip_duration <- get_trip_duration(gtfs, trip_id = trip_ids)
trip_duration

trip_duration <- get_trip_duration(gtfs, trip_id = trip_ids, unit = "h")
trip_duration

}
