% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{set_gt_api_key}
\alias{set_gt_api_key}
\title{Set up a GOOGLE TRENDS FOR HEALTH API Key for Repeated Use}
\usage{
set_gt_api_key(key, overwrite = FALSE, install = FALSE, path = "HOME")
}
\arguments{
\item{key}{The API key from your Google Developer project authorized for
Google Trends for Health API use, formatted in quotes.
A key can be acquired by requesting access at
\url{https://support.google.com/trends/contact/trends_api} and following the
setup instructions.}

\item{overwrite}{If this is set to TRUE, it will overwrite an existing
CENSUS_API_KEY that you already have in your \code{.Renviron} file.}

\item{install}{if TRUE, will install the key in your \code{.Renviron} file
for use in future sessions. Defaults to FALSE.}

\item{path}{Path to install the API key into.}
}
\value{
Returns the API key that was saved to the
GOOGLE_TRENDS_FOR_HEALTH_API_KEY environment variable.
If \code{install = TRUE}, it saves the API key in the specified .Renviron
file.
}
\description{
This function will set your GOOGLE TRENDS FOR HEALTH API key
as an environment variable.
If using \code{install =  TRUE} then the key will also be saved to your
 \code{.Renviron} file so it can be called securely without being stored
in your code. After you have installed your key, it can be called any time by
typing \code{Sys.getenv("GOOGLE_TRENDS_FOR_HEALTH_API_KEY")} and can be
used in package functions by simply typing GOOGLE_TRENDS_FOR_HEALTH_API_KEY
If you do not have an \code{.Renviron} file, the function will create one
for you. If you already have an \code{.Renviron} file, the function will
append the key to your existing file, while making a backup of your
original file for recovery purposes.
}
\examples{

set_gt_api_key("111111abc", install = TRUE, path = tempdir())
# The first time, reload your environment so you can use the key without
# restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("GOOGLE_TRENDS_FOR_HEALTH_API_KEY")

# If you need to overwrite an existing key:
set_gt_api_key(
  "111111abc", overwrite = TRUE, install = TRUE, path = tempdir()
)
# The first time, reload your environment so you can use the key without
# restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("GOOGLE_TRENDS_FOR_HEALTH_API_KEY")

# clean up
unlink(
list.files(tempdir(), all.files = TRUE, full.names = TRUE, pattern = ".Renv")
)
}
