% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.tbl_survfit.R
\name{add_p.tbl_survfit}
\alias{add_p.tbl_survfit}
\title{Add p-value}
\usage{
\method{add_p}{tbl_survfit}(
  x,
  test = "logrank",
  test.args = NULL,
  pvalue_fun = label_style_pvalue(digits = 1),
  include = everything(),
  quiet,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_survfit})\cr
Object of class \code{"tbl_survfit"}}

\item{test}{(\code{string})\cr
string indicating test to use. Must be one of \code{"logrank"}, \code{"tarone"}, \code{"survdiff"},
\code{"petopeto_gehanwilcoxon"}, \code{"coxph_lrt"}, \code{"coxph_wald"}, \code{"coxph_score"}.
See details below}

\item{test.args}{(named \code{list})\cr
named list of arguments that will be passed to the method specified in the
\code{test} argument.
Default is \code{NULL}.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
Calculate and add a p-value to stratified \code{\link[=tbl_survfit]{tbl_survfit()}} tables.
}
\section{test argument}{

The most common way to specify \verb{test=} is by using a single string indicating
the test name. However, if you need to specify different tests within the same
table, the input in flexible using the list notation common throughout the
gtsummary package. For example, the following code would call the log-rank test,
and a second test of the \emph{G-rho} family.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{... |>
  add_p(test = list(trt ~ "logrank", grade ~ "survdiff"),
        test.args = grade ~ list(rho = 0.5))
}\if{html}{\out{</div>}}
}

\section{Note}{


To calculate the p-values, the formula is re-constructed from the the call in the
original \code{survfit()} object.
When the \code{survfit()} object is created a for loop, \code{lapply()}, \code{purrr::map()}
setting the call \emph{may not} reflect the true formula which may result in an
error or an incorrect calculation.

To ensure correct results, the call formula in \code{survfit()} must represent the
formula that will be used in \code{survival::survdiff()}.
If you utilize the \code{tbl_survfit.data.frame()} S3 method, this is handled for you.
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("survival", "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

gts_survfit <-
  list(
    survfit(Surv(ttdeath, death) ~ grade, trial),
    survfit(Surv(ttdeath, death) ~ trt, trial)
  ) |>
  tbl_survfit(times = c(12, 24))

# Example 1 ----------------------------------
gts_survfit |>
  add_p()

# Example 2 ----------------------------------
# Pass `rho=` argument to `survdiff()`
gts_survfit |>
  add_p(test = "survdiff", test.args = list(rho = 0.5))
\dontshow{\}) # examplesIf}
}
\seealso{
Other tbl_survfit tools: 
\code{\link{add_nevent.tbl_survfit}()}
}
\concept{tbl_survfit tools}
