% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editions.R
\name{gu_editions}
\alias{gu_editions}
\title{Editions}
\usage{
gu_editions(query = NULL, ..., verbose = TRUE, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{query}{A string, which will return editions based on that string.
Defaults to \code{NULL} and returns all editions. Strings are not case sensitive.}

\item{...}{Pass additional options to API. There are no additional
options as of this writing. See the
\href{https://open-platform.theguardian.com/documentation/edition}{endpoint docs}}

\item{verbose}{Prints messages to console. Defaults to \code{TRUE}.}

\item{tidy}{Convert variable names to snake_case, remove some \code{"<NA>"}
strings. Defaults to \code{TRUE}.}

\item{tidy_style}{Style to variable names with.}
}
\value{
A tibble with details of the given edition.
}
\description{
The different main pages of the Guardian. As of January 2019 they are the
United Kingdom ("uk"), the United States ("us"), Australia ("au") and
an International ("international") front page.
}
\examples{
\dontrun{
uk <- gu_editions(query = "uk")
}

}
