% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{resolve_run_ids}
\alias{resolve_run_ids}
\title{Resolve run ids}
\usage{
resolve_run_ids(runs = NULL, ..., all = TRUE)
}
\arguments{
\item{runs}{a runs selection. If a data.frame, the columns \code{id} or
\code{run} are used as the run id. Otherwise, the arguments are
transformed into a character vector of cli arguments, and passed on
to \code{guild} as a runs filter selection. Wrap the string in \code{I()} to
avoid quoting the argument for the shell.}

\item{...}{Other arguments passed on to \code{guild}}

\item{all}{Return all matching runs. If \code{FALSE}, it returns the
singly most recent run matching the selection criteria.}
}
\value{
A character vector of run ids.
}
\description{
This is a equivalent to \code{runs_info(...)$id}, implemented more
efficiently.
}
\details{
guild supports a rich syntax for runs selection throughout the api.
The same selection syntax is shared by the \verb{runs_*} family of
functions: \code{runs_info()}, \code{runs_scalars()}, \code{runs_comment()},
\code{runs_label()}, \code{runs_mark()}, \code{runs_tag()}
\code{runs_delete()},\code{runs_purge()}, \code{runs_restore()}, \code{runs_export()},
\code{runs_import()}.
}
\note{
You can call \code{Sys.setenv(GUILD_DEBUG_R = 1)} to see what system
calls to the \code{guild} executable are made. This is useful when
looking to understand how R arguments are transformed into a cli
system call.
}
\examples{
\dontrun{
resolve_run_ids() # returns all run ids.
resolve_run_ids(1) # last run
resolve_run_ids(1:2) # last 2 runs
resolve_run_ids(1:2, operation = "train.py")

# three ways of getting ids for the currently staged or running runs
resolve_run_ids(staged = TRUE, running = TRUE)
resolve_run_ids("--staged", "--running")
resolve_run_ids(c("--staged", "--running"))
resolve_run_ids(I("--staged --running"))

# resolve_run_ids() uses the same selection rules and syntax as runs_info()
stopifnot(identical(
  resolve_run_ids(),
  runs_info()$id
))
}
}
