% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwrpv.R
\name{gwrpv}
\alias{gwrpv}
\title{Genome-Wide Regression P-Value (gwrpv) in R}
\usage{
gwrpv(beta, n0, n1, n2, mua, siga, mub, sigb, pa, pb, logdelta = -16,
  lognearnorm = -5, logtopsum = 8)
}
\arguments{
\item{beta}{the beta being tested}

\item{n0}{number of major allele homozygotes}

\item{n1}{number of major allele heterozygotes}

\item{n2}{number of minor allele zygotes}

\item{mua}{parameter of the mixture distribution, can be any real number}

\item{siga}{parameter of the mixture distribution, can be any real number}

\item{mub}{parameter of the mixture distribution, can be any real number}

\item{sigb}{parameter of the mixture distribution, can be any real number}

\item{pa}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{pb}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{logdelta}{must be in log base 10 format, with default value set to -16}

\item{lognearnorm}{must be in log base 10 format, with default value set to -5}

\item{logtopsum}{must be in log base 10 format, with default value set to 8}
}
\value{
gwrpv returns a list containing:
\describe{
  \item{$pvalue}{p-value of a two-sided hypothesis test for a true coefficient of zero}
  \item{$skew}{skewness}
  \item{$kurt}{kurtosis of the coefficient estimate under assumed model}
  \item{$skiptype}{type of trimming/skip which took place (zero means no trimming)}
  \item{$totnobs}{total number of observations}
  \item{$loopruns}{number of sums in the main computation for each regression case}
}


                      .
}
\description{
Computes the sample probability value (p-value) for the estimated coefficient
from a standard genome-wide univariate regression.
It computes the exact finite-sample p-value under the assumption that
the measured phenotype (the dependent variable in the regression)
has a known Bernoulli-normal mixture distribution.
}
\examples{
beta <- 6.05879
n0 <- 499
n1 <- 1
n2 <- 0
mua <- 13.87226
siga <- 2.58807
mub <- 4.62829
sigb <- 2.51803
pa <- 0.96544
pb <- 0.03456    # alternatively: pb <- 1.0 - pa
gwrpv(beta,n0,n1,n2,mua,siga,mub,sigb,pa,pb)

# note default values have been used for the trim parameters above
# in the following example we explicitly set the trim parameters
#
g <- gwrpv(beta,n0,n1,n2,mua,siga,mub,sigb,pa,pb,logdelta=-16,lognearnorm=-5,logtopsum=8)
g$pvalue
}

