% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{.process_models_or_automl}
\alias{.process_models_or_automl}
\title{Do basic validation and transform \code{object} to a "standardized" list containing models, and
their properties such as \code{x}, \code{y}, whether it is a (multinomial) clasification or not etc.}
\usage{
.process_models_or_automl(
  object,
  newdata,
  require_single_model = FALSE,
  require_multiple_models = FALSE,
  top_n_from_AutoML = NA,
  only_with_varimp = FALSE,
  best_of_family = FALSE,
  require_newdata = TRUE,
  check_x_y_consistency = TRUE
)
}
\arguments{
\item{object}{Can be a single model/model_id, vector of model_id, list of models, H2OAutoML object}

\item{newdata}{An H2OFrame with the same format as training frame}

\item{require_single_model}{If true, make sure we were provided only one model}

\item{require_multiple_models}{If true, make sure we were provided at least two models}

\item{top_n_from_AutoML}{If set, don't return more than top_n models (applies only for AutoML object)}

\item{only_with_varimp}{If TRUE, return only models that have variable importance}

\item{best_of_family}{If TRUE, return only the best of family models; if FALSE return all models in \code{object}}

\item{require_newdata}{If TRUE, require newdata to be specified; otherwise allow NULL instead, this can be used when
there is no need to know if the problem is (multinomial) classification.}

\item{check_x_y_consistency}{If TRUE, make sure that when given a list of models all models have the same X and y. Defaults to TRUE.}
}
\value{
a list with the following names \code{leader}, \code{is_automl}, \code{models},
  \code{is_classification}, \code{is_multinomial_classification}, \code{x}, \code{y}, \code{model}
}
\description{
Do basic validation and transform \code{object} to a "standardized" list containing models, and
their properties such as \code{x}, \code{y}, whether it is a (multinomial) clasification or not etc.
}
