% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgrm.R
\name{hgrm}
\alias{hgrm}
\title{Fitting Hierarchical Graded Response Models (for Ordinal Responses)}
\usage{
hgrm(
  y,
  x = NULL,
  z = NULL,
  constr = c("latent_scale", "items"),
  beta_set = 1L,
  sign_set = TRUE,
  init = c("naive", "glm", "irt"),
  control = list()
)
}
\arguments{
\item{y}{A data frame or matrix of item responses.}

\item{x}{An optional model matrix, including the intercept term, that predicts the
mean of the latent preference. If not supplied, only the intercept term is included.}

\item{z}{An optional model matrix, including the intercept term, that predicts the
variance of the latent preference. If not supplied, only the intercept term is included.}

\item{constr}{The type of constraints used to identify the model: "latent_scale",
or "items". The default, "latent_scale" constrains the mean of latent preferences
to zero and the geometric mean of prior variance to one; "items" places constraints
on item parameters instead and sets the mean of item difficulty parameters to zero
and the geometric mean of the discrimination parameters to one.}

\item{beta_set}{The index of the item for which the discrimination parameter is
restricted to be positive (or negative). It may take any integer value from
1 to \code{ncol(y)}.}

\item{sign_set}{Logical. Should the discrimination parameter of
the corresponding item (indexed by \code{beta_set}) be positive
(if \code{TRUE}) or negative (if \code{FALSE})?}

\item{init}{A character string indicating how item parameters are initialized. It can be
"naive", "glm", or "irt".}

\item{control}{A list of control values
\describe{
 \item{max_iter}{The maximum number of iterations of the EM algorithm.
   The default is 150.}
 \item{eps}{Tolerance parameter used to determine convergence of the
  EM algorithm. Specifically, iterations continue until the Euclidean
  distance between \eqn{\beta_{n}} and \eqn{\beta_{n-1}} falls under \code{eps},
  where \eqn{\beta} is the vector of item discrimination parameters.
  \code{eps}=1e-4 by default.}
 \item{max_iter2}{The maximum number of iterations of the conditional
   maximization procedures for updating \eqn{\gamma} and \eqn{\lambda}.
   The default is 15.}
 \item{eps2}{Tolerance parameter used to determine convergence of the
   conditional maximization procedures for updating \eqn{\gamma} and
   \eqn{\lambda}. Specifically, iterations continue until the Euclidean
  distance between two consecutive log likelihoods falls under \code{eps2}.
  \code{eps2}=1e-3 by default.}
 \item{K}{Number of Gauss-Legendre quadrature points for the E-step. The default is 21.}
 \item{C}{[-C, C] sets the range of integral in the E-step. \code{C}=3 by default.}
}}
}
\value{
An object of class \code{hgrm}.
 \item{coefficients}{A data frame of parameter estimates, standard errors,
  z values and p values.}
 \item{scores}{A data frame of EAP estimates of latent preferences and
  their approximate standard errors.}
 \item{vcov}{Variance-covariance matrix of parameter estimates.}
 \item{log_Lik}{The log-likelihood value at convergence.}
 \item{N}{Number of units.}
 \item{J}{Number of items.}
 \item{H}{A vector denoting the number of response categories for each item.}
 \item{ylevels}{A list showing the levels of the factorized response categories.}
 \item{p}{The number of predictors for the mean equation.}
 \item{q}{The number of predictors for the variance equation.}
 \item{control}{List of control values.}
 \item{call}{The matched call.}
}
\description{
\code{hgrm} fits a hierarchical graded response model in which both
the mean and the variance of the latent preference (ability parameter)
may depend on person-specific covariates (\code{x} and \code{z}).
Specifically, the mean is specified as a linear combination of \code{x}
and the log of the variance is specified as a linear combination of
\code{z}. Nonresponses are treated as missing at random.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
nes_m1
}
\references{
Zhou, Xiang. 2019. "\href{https://doi.org/10.1017/pan.2018.63}{Hierarchical Item Response Models for Analyzing Public Opinion.}" Political Analysis.
}
