% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cond_A.R
\name{get_cond_A}
\alias{get_cond_A}
\title{Compute conditional Z matrix}
\usage{
get_cond_A(marginal_A, Gl, N.Gx, ridgeTerm = FALSE)
}
\arguments{
\item{marginal_A}{the marginal effects of SNPs on the exposures (Gx).}

\item{Gl}{the reference panel (Gl), such as 1000 Genome}

\item{N.Gx}{the sample size of each Gx. It can be a scalar or a vector. If there are multiple X's from different Gx, it should be a vector including the sample size of each Gx. If all alphas are from the same Gx, it could be a scalar.}

\item{ridgeTerm}{ridgeTerm = TRUE when the matrix L is singular. Matrix L is obtained from the cholesky decomposition of G0'G0. Default as FALSE.}
}
\value{
A matrix with conditional estimates which are converted from marginal estimates using the JAM model.
}
\description{
The get_cond_A function is to get the conditional A matrix by using marginal A matrix
}
\examples{
data(Gl)
data(betas.Gy)
data(marginal_A)
get_cond_A(marginal_A = marginal_A, Gl = Gl, N.Gx = c(339224, 659316), ridgeTerm = TRUE)
}
\author{
Lai Jiang
}
