% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/han_autoencoder.R
\name{han_autoencoder}
\alias{han_autoencoder}
\title{Anomaly detector using autoencoders}
\usage{
han_autoencoder(input_size, encode_size, encoderclass = autoenc_base_ed, ...)
}
\arguments{
\item{input_size}{Integer. Input (and output) window size for the autoencoder.}

\item{encode_size}{Integer. Size of the encoded (bottleneck) representation.}

\item{encoderclass}{DALToolbox encoder-decoder constructor to instantiate.}

\item{...}{Additional arguments forwarded to \code{encoderclass}.}
}
\value{
\code{han_autoencoder} object
}
\description{
Trains an encoder-decoder (autoencoder) to reconstruct sliding windows of the
series; large reconstruction errors indicate anomalies.
}
\examples{
library(daltoolbox)
library(tspredit)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure an autoencoder-based anomaly detector
model <- han_autoencoder(input_size = 5, encode_size = 3)

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Inspect detected anomalies
print(detection[detection$event, ])

}
\references{
\itemize{
\item Sakurada M, Yairi T (2014). Anomaly Detection Using Autoencoders with
Nonlinear Dimensionality Reduction. MLSDA 2014.
}
}
