% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_binseg.R
\name{hcp_binseg}
\alias{hcp_binseg}
\title{Binary Segmentation (BinSeg)}
\usage{
hcp_binseg(Q = 2)
}
\arguments{
\item{Q}{Integer. Maximum number of change points to search for.}
}
\value{
\code{hcp_binseg} object.
}
\description{
Multi-change-point detection via Binary Segmentation on mean/variance using
the \code{changepoint} package.
}
\details{
Binary Segmentation recursively partitions the series around the largest
detected change until a maximum number of change points or stopping criterion
is met. This is a fast heuristic widely used in practice.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure the BinSeg detector
model <- hcp_binseg()

# Fit the detector (no-op for BinSeg)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Vostrikova L (1981). Detecting "disorder" in multidimensional random processes. Soviet Mathematics Doklady, 24, 55–59.
\item Killick R, Fearnhead P, Eckley IA (2012). Optimal detection of changepoints with a linear computational cost. JASA, 107(500):1590–1598. \link[dplyr:context]{dplyr::context}
}
}
