% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbbrAugResponseSim.R
\docType{data}
\name{simAugData}
\alias{simAugData}
\title{A list consisting of simulated data, design, baseline profiles, and true part-worth matrix
for the Augmented HBBR model framework.}
\format{A list consisting of simulated response data from 100 subjects, design information,
baseline profiles, and true part-worth matrix of the Augmented HBBR model framework.

\describe{
   \item{brdtaAug}{A data frame of 100x12 rows and 10 columns consists of simulated responses from
   100 subjects each providing tradeoff responses to 12 choice pairs. The 1st column consists of
   subject id. The 2nd column contains binary responses (1 indicating 1st of the choice
   pair was selected, 0 indicating 2nd was selected). Remaining 8 columns
   contain the design matrix X taking values 0, 1, or -1; a value of 1 or -1 is used to
   indicate presence of an attribute level in the 1st choice or in the 2nd choice of the choice
   pair, respectively; a value of 0 is used to indicate absence of an attribute in the
   choice pair.  See Details below for more about the discrete choice experiment that is coded as
   design matrix X.}
   \item{design}{A list of structure (b, r, bl, rl), where b and r indicate number of benefit
   and risk attributes, bl is a vector of integers of size b consisting number of levels within
   each benefit attribute; similarly rl is a vector of integers of size r consisting number
   of levels within each risk attribute.}
   \item{Z}{A data frame of size 100x3 consists of baseline characteristics from 100 subjects.
   The 1st column of Z is vector of 1, the 2nd column consists of standardized age, and
   the 3rd column indicates disease status at baseline (1= present, -1 = not present).
   The 1st  column being a constant vector of 1 indicates that the part-worth matrix to be estimated,
   say Del-hat, would have the overall mean part-worth in the 1st column, while 2nd and 3rd
   columns would consists of estimates of additive components of part-worth due to age and
   disease status.}
   \item{Del}{A matrix of true part-worth values of dimension 8x3. This was used along with
   X and Z to generate the responses from 100 subjects captured in the 2nd column of brdtaSim.}
}}
\usage{
data(simAugData)
}
\description{
Simulated response data and associated information from 100 respondents each choosing
preference from 12 choice cards. Choice cards were randomly generated from 36 total choices.
}
\details{
The simulated discrete choice experiment (DCE) included 3 benefit
         attributes (b=2): B1, B2 (say) and 2 risk attributes (r=2): R1, R2 (say).
         There were 3 levels for each of the benefit attributes ("Low", "Moderate", "High")
         (i.e. bl= rep(3,2)) and
         3 levels for each of the risk attributes ("None", "Mild", "Severe")
         (i.e. rl = rep(3,2)).
         The DCE produced 36 distinct non-dominant choice pairs each with one benefit and one
         risk attribute. Panels (questionnaires) were generated with 12 (randomly) selected
         choice pairs per panel from the set of 36 choice pairs. Since the part-worth of various levels
         within each attribute are to be measured relatively to the part-worth of the 1st level of the
         attribute, columns for the 1st level of the attributes are not required. Thus, we have sum(bl)-b
         + sum(br)-r = 8 columns are needed to obtain information on the X matrix which are stored
         as the last 8 columns of brdtaAugSim.
}
\examples{
data(simAugData)
}
\keyword{datasets}
