% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{plot.sae}
\alias{plot.sae}
\title{Plot method for objects of class sae.}
\usage{
\method{plot}{sae}(
  ...,
  n.se = 1,
  est.names,
  sort.by = NULL,
  decreasing = FALSE,
  index = NULL,
  maxrows = 50L,
  maxcols = 6L,
  type = "sae",
  offset = 0.1,
  cex.var = 0.8,
  mar = c(0.1, 2.1, 5.1, 0.1)
)
}
\arguments{
\item{...}{\code{sae} objects, \code{dc_summary} objects (output by the \code{summary} method for
simulation objects of package \pkg{mcmcsae}), or lists.
The first object must be a \code{sae} object.
In case of a list the components
used are those with name \code{est} for point estimates, \code{se}
for standard error based intervals or \code{lower} and \code{upper} for
custom intervals. Instead of \code{dc_summary} objects matrix objects are
also supported as long as they contain columns named "Mean" and "SD" as do
\code{dc_summary} objects. Named parameters of other types that do not match any
other argument names are passed to lower-level plot functions.}

\item{n.se}{number of standard errors below and above the point estimates
to use for error bars. By default equal to 1. This only refers to the
objects of class \code{dc_summary} and \code{sae}.}

\item{est.names}{labels to use in the legend for the components of the \code{...} argument}

\item{sort.by}{vector by which to sort the coefficients, referring to the first object passed.}

\item{decreasing}{if \code{TRUE}, sort in decreasing order (default).}

\item{index}{vector of names or indices of the selected areas to be plotted.}

\item{maxrows}{maximum number of rows in a column.}

\item{maxcols}{maximum number of columns of estimates on a page.}

\item{type}{"sae" for small area estimates (default), "coef" for
coefficients, "raneff" for random effects.}

\item{offset}{space used between plots of multiple estimates for the same
area.}

\item{cex.var}{the fontsize of the variable names, default=0.8.}

\item{mar}{a numerical vector of the form c(bottom, left, top, right) which
gives the number of lines of margin to be specified on the four sides of
the plot.}
}
\description{
This function plots small area estimates with error bars.
Multiple sets of estimates can be compared. The default ordering of the estimates
is by their area population sizes.
This method uses a plot function that is adapted from function
\code{coefplot.default} of package \pkg{arm}.
}
