% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbsae.R
\name{hbsae}
\alias{hbsae}
\title{hbsae : Hierarchical Bayesian Small Area Estimation}
\usage{
hbsae(model, newdata = NULL)
}
\arguments{
\item{model}{A \code{brmsfit} or \code{hbmfit} object, a fitted model from the \code{brms} package and \code{hbsaems} package.}

\item{newdata}{A dataset for making predictions.}
}
\value{
An object of class \code{hbsae_results}, which is a list containing:
\item{rse_model}{A numeric value indicating the overall relative standard error (RSE) of the model.}
\item{mse_model}{A numeric value indicating the overall mean squared error (MSE) of the model estimates, representing the average estimation error across areas.}
\item{result_table}{A \code{data.frame} containing predictions and associated statistics for each small area.}
}
\description{
This function performs Hierarchical Bayesian Small Area Estimation (HBSAE).
It estimates predictions and computes the Relative Standard Error (RSE) based on the posterior predictive sample from the fitted Bayesian model.
}
\details{
Hierarchical Bayesian Small Area Estimation
}
\examples{
\donttest{

library(hbsaems)
data("data_fhnorm")

# Prepare the dataset
data <- data_fhnorm

# Fit the Basic Model
model <- hbm(
formula = bf(y ~ x1 + x2 + x3), # Formula model
hb_sampling = "gaussian", # Gaussian family for continuous outcomes
hb_link = "identity", # Identity link function (no transformation)
data = data, # Dataset
chains = 4, # Number of MCMC chains
iter = 4000, # Total MCMC iterations
warmup = 2000, # Number of warmup iterations
cores = 2 # Parallel processing
)
summary(model)

# Small Area Estimates
hbsae(model)
}
}
\references{
Bürkner, P. C. (2017). brms: An R package for Bayesian multilevel models using Stan. \emph{Journal of Statistical Software}, 80(1), 1-28.
}
\author{
Achmad Syahrul Choir and Saniyyah Sri Nurhayati
}
