% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize_descriptives}
\alias{summarize_descriptives}
\title{Generate Detailed Descriptive Statistics}
\usage{
summarize_descriptives(
  data,
  patient_id_col = "patient_id",
  setting_col = "care_setting",
  cohort_col = "cohort",
  encounter_id_col = "encounter_id",
  cost_col = "cost_usd",
  los_col = "length_of_stay",
  readmission_col = "readmission",
  time_window_col = "time_window"
)
}
\arguments{
\item{data}{A dataframe with variables to summarize.}

\item{patient_id_col}{A character specifying the name of patient
identifier column}

\item{setting_col}{A character specifying the name of HRCU setting column}

\item{cohort_col}{A character specifying the name of cohort column}

\item{encounter_id_col}{A character specifying the name of encounter/claim
column}

\item{cost_col}{A character specifying the name of cost column}

\item{los_col}{A character specifying the name of length of stay column}

\item{readmission_col}{A character specifying the name of readmission column}

\item{time_window_col}{A character specifying the name of time window column}
}
\value{
A table object
}
\description{
Generate Detailed Descriptive Statistics
}
\examples{
if (requireNamespace("dplyr", quietly = TRUE) &&
    requireNamespace("checkmate", quietly = TRUE)) {
  hcru_sample_data <- data.frame(
    patient_id = rep(1:10, each = 2),
    cohort = rep(c("A", "B"), 10),
    care_setting = rep(c("IP", "OP"), 10),
    admission_date = Sys.Date() - sample(1:100, 20, TRUE),
    discharge_date = Sys.Date() - sample(1:90, 20, TRUE),
    index_date = Sys.Date() - 50,
    visit_date = Sys.Date() - sample(1:100, 20, TRUE),
    encounter_id = 1:20,
    cost_usd = runif(20, 100, 1000)
  )
  df <- preproc_hcru_fun(data = hcru_sample_data)
  summary_df <- summarize_descriptives(data = df)
  # Only keep required columns for demonstration
  summary_df$LOS <- ifelse(summary_df$care_setting == "IP",
    sample(1:10, nrow(summary_df), TRUE), NA)
  summary_df$Readmission <- ifelse(summary_df$care_setting == "IP",
    sample(0:1, nrow(summary_df), TRUE), NA)
  summary_df$time_window <- "Pre"
  summary_df
}
}
