% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfectSample.R
\name{perfectSample}
\alias{perfectSample}
\alias{perfectSample.MTD}
\title{Perfectly samples an MTD Markov chain}
\usage{
perfectSample(object, ...)

\method{perfectSample}{MTD}(object, N, ...)
}
\arguments{
\item{object}{An object of class "MTD", see \code{\link[=MTDmodel]{MTDmodel()}} for properly generating}

\item{...}{Additional arguments passed to methods.
an MTD object.}

\item{N}{Positive integer. Sample size to generate. Must be > max(Lambda(object)).}
}
\value{
Returns a size N sample from an MTD model (the first element is the most recent).
}
\description{
Samples an MTD Markov Chain from the stationary distribution.
}
\details{
This perfect sample algorithm requires that the MTD model has
an independent distribution (p0) with a positive weight (i.e., \code{lambdas(object)["lam0"]>0}
which means \eqn{\lambda_0>0}).
}
\examples{
M <- MTDmodel(Lambda = c(1, 3, 4), A = c(0, 2))
perfectSample(M, N = 200)

M <- MTDmodel(Lambda = c(2, 5), A = c(1, 2, 3))
perfectSample(M, N = 300)

}
