% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{clean.cp}
\alias{clean.cp}
\title{Removing change-points in the mean}
\usage{
clean.cp(z, type = c("dcbs", "sbs"), phi = 0.5, trim = NULL, height = NULL)
}
\arguments{
\item{z}{input data matrix, with each row representing the component time series}

\item{type}{if \code{type = 'dcbs'}, a binary tree of given \code{height} is grown using DCBS algorithm without thresholding, if \code{type = 'sbs'}, the binary trees is grown using the SBS algorithm with thresholds chosen small}

\item{phi, trim, height}{see \code{\link{dcbs.alg}}}
}
\value{
a list containing
\item{x}{\code{z} with potential change-points in the mean removed}
\item{z}{\code{mat} object of an S3 \code{bin.tree} object}
}
\description{
(Over-)estimate and remove change-points in the mean for scale estimation and bootstrapping
}
\keyword{internal}
