% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{print.hdd}
\alias{print.hdd}
\title{Print method for HDD objects}
\usage{
\method{print}{hdd}(x, ...)
}
\arguments{
\item{x}{A \code{HDD} object.}

\item{...}{Not currently used.}
}
\value{
Nothing is returned.
}
\description{
This functions displays the first and last lines of a hard drive data set (HDD).
}
\details{
Returns the first and last 3 lines of a HDD object. Also formats the values displayed on screen (typically: add commas to increase the readability of large integers).
}
\examples{

# Toy example with iris data
iris_path = tempfile()
fwrite(iris, iris_path)

# destination path
hdd_path = tempfile()

# reading the text file with 50 rows chunks:
txt2hdd(iris_path, dirDest = hdd_path, rowsPerChunk = 50)

# creating a HDD object
base_hdd = hdd(hdd_path)

# Summary information on the whole data set
summary(base_hdd)

# Looking at it like a regular data.frame
print(base_hdd)
dim(base_hdd)
names(base_hdd)



}
\seealso{
See \code{\link[hdd]{hdd}}, \code{\link[hdd]{sub-.hdd}} and \code{\link[hdd]{cash-.hdd}}
for the extraction and manipulation of out of memory data. For importation of
HDD data sets from text files: see \code{\link[hdd]{txt2hdd}}.

See \code{\link[hdd]{hdd_slice}} to apply functions to chunks of data (and create
HDD objects) and \code{\link[hdd]{hdd_merge}} to merge large files.

To create/reshape HDD objects from memory or from other HDD objects, see
\code{\link[hdd]{write_hdd}}.

To display general information from HDD objects: \code{\link[hdd]{origin}},
\code{\link[hdd]{summary.hdd}}, \code{\link[hdd]{print.hdd}},
\code{\link[hdd]{dim.hdd}} and \code{\link[hdd]{names.hdd}}.
}
\author{
Laurent Berge
}
