% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_summaries.R
\name{plot.hdpGLM}
\alias{plot.hdpGLM}
\title{Plot}
\usage{
\method{plot}{hdpGLM}(
  x,
  terms = NULL,
  j.label = NULL,
  j.idx = NULL,
  title = NULL,
  subtitle = NULL,
  true.beta = NULL,
  ncol = NULL,
  legend.position = "bottom",
  display.terms = TRUE,
  context.id = NULL,
  ylab = NULL,
  xlab = NULL,
  x.axis.size = 1.1,
  y.axis.size = 1.1,
  title.size = 1.2,
  panel.title.size = 1.5,
  legend.size = 1.1,
  rel.height = 0.01,
  fill.col = "#00000044",
  border.col = "white",
  ...
)
}
\arguments{
\item{x}{an object of the class \code{hdpGLM} generted by the function \link{hdpGLM}}

\item{terms}{string vector with the name of the individual-level covariates to plot. If \code{NULL} (default), all covariates are plotted.}

\item{j.label}{string vector with the names of the contexts to plot. An alternative is to use the context indexes with the parameter \code{j.idx} instead of the context labels. If \code{NULL} (default) and j.idx is also \code{NULL}, the posterior distribution of all contexts are plotted. Note: if contexts to plot are selected using \code{j.label}, the parameter \code{context.id} must also be provided.}

\item{j.idx}{integer vector with the index of the contexts to plot. An alternative is to use the context labels with the parameter \code{j.label} instead of the indexes. If \code{NULL} (default) and j.label is also \code{NULL}, the posterior distribution of all contexts are plotted}

\item{title}{string, the title of the plot}

\item{subtitle}{string, the subtitle of the plot}

\item{true.beta}{a \code{data.frame} with the true values of the linear coefficients \code{beta} if they are known. The \code{data.frame} must contain a column named \code{j} with the index of the context associated with that particular linear coefficient \code{beta}. It must match the indexes used in the data set for each context. Another column named \code{k} must be provided, indicating the cluster of \code{beta}, and a column named \code{Parameter} with the name of the linear coefficients (\code{beta1}, \code{beta2}, ..., \code{beta_dx}, where \code{dx} is the number of covariates at the individual level, and beta1 is the coefficient of the intercept term). It must contain a column named \code{True} with the true value of the \code{betas}. Finally, the \code{data.frame} must contain columns with the context-level covariates as used in the estimation of the \link{hdpGLM} function (see Details below).}

\item{ncol}{interger, the number of columns in the plot}

\item{legend.position}{one of four options: "bottom" (default), "top", "left", or "right". It indicates the position of the legend}

\item{display.terms}{boolean, if \code{TRUE} (default), the covariate name is displayed in the plot}

\item{context.id}{string with the name of the column containing the labels identifying the contexts. This variable should have been specified when the estimation was conducted using the function \code{\link{hdpGLM}}.}

\item{ylab}{string, the label of the y-axis}

\item{xlab}{string, the label of the x-axis}

\item{x.axis.size}{numeric, the relative size of the label in the x-axis}

\item{y.axis.size}{numeric, the relative size of the label in the y-axis}

\item{title.size}{numeric, the relative size of the title of the plot}

\item{panel.title.size}{numeric, the relative size of the titles in the panel of the plot}

\item{legend.size}{numeric, the relative size of the legend}

\item{rel.height}{see ggridges::geom_density_ridges}

\item{fill.col}{string with the color of the densities}

\item{border.col}{string with the color of the border of the densities}

\item{...}{Additional arguments accepted are:

           \code{true.beta}: a \code{data.frame} with the true values of the linear coefficients \code{beta} if they are known. The \code{data.frame} must contain a column named \code{j} with the index of the context associated with that particular linear coefficient \code{beta}. It must match the indexes used in the data set for each context. Another column named \code{k} must be provided, indicating the cluster of \code{beta}, and a column named \code{Parameter} with the name of the linear coefficients (\code{beta1}, \code{beta2}, ..., \code{beta_dx}, where \code{dx} is the number of covariates at the individual level, and beta1 is the coefficient of the intercept term). It must contain a column named \code{True} with the true value of the \code{betas}. Finally, the \code{data.frame} must contain columns with the context-level covariates as used in the estimation of the \link{hdpGLM} function (see Details below).

           \code{true.tau}: a \code{data.frame} with four columns. The first must be named \code{w} and it indicates the index of each context-level covariate, starting with 0 for the intercept term. The second column named \code{beta} must contain the indexes of the betas of individual-level covariates, starting with 0 for the intercept term. The third column named \code{Parameter} must be named \code{tau<w><beta>}, where \code{w} and \code{beta} must be the actual values displayed in the columns \code{w} and \code{beta}. Finally, it must have a column named \code{True} with the true value of the parameter.}
}
\description{
Generic function to plot the posterior density estimation produced by the function \code{hdpGLM}
}
