% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2.R
\name{step2}
\alias{step2}
\title{step2: Two-Step Estimation Function}
\usage{
step2(YS, XS, YO, XO, Msigma, Mrho, w)
}
\arguments{
\item{YS}{A binary numeric vector indicating selection (1 if selected, 0 otherwise).}

\item{XS}{A numeric matrix of covariates for the selection equation. Rows correspond to observations and columns to covariates.}

\item{YO}{A numeric vector of observed outcomes for the selected sample (where \code{YS == 1}).}

\item{XO}{A numeric matrix of covariates for the outcome equation. Rows correspond to selected observations.}

\item{Msigma}{A numeric matrix of covariates for the dispersion equation.}

\item{Mrho}{A numeric matrix of covariates for the correlation structure equation.}

\item{w}{A numeric vector of weights to be used in the estimation process.}
}
\value{
A list with the following elements:
\item{selection}{Estimated coefficients for the selection equation (probit model).}
\item{outcome}{Estimated coefficients for the outcome equation (weighted least squares).}
\item{dispersion}{Estimated coefficients for the dispersion equation (log of residual variance).}
\item{correlation}{Initial guesses for the coefficients in the correlation structure.}
}
\description{
This function performs a two-step estimation process, commonly used in models that require correction for sample selection bias. It estimates parameters for selection, outcome, and dispersion equations.
}
\details{
This function implements a two-step estimation method for models with sample
selection bias. The process begins by estimating the selection equation using
a probit model to model the probability of selection. The Inverse Mills Ratio (IMR)
is computed from the probit model and added as a covariate in the outcome and
dispersion equations to correct for sample selection bias.

The outcome equation is estimated using weighted least squares (WLS), where
the residuals are used to estimate the dispersion equation. Additionally,
initial estimates for the correlation structure are computed based on the
fitted values from the outcome equation.
}
\seealso{
\code{\link[sandwich]{vcovHC}} for computing robust standard errors.
}
