
<!-- README.md is generated from README.Rmd. Please edit that file -->

# heiscore.data

<!-- badges: start -->
<!-- badges: end -->

The heiscore.data package contains the dietary recall data used by the
heiscore package. The datasets include National Health and Nutrition
Examination Survey (NHANES) data converted to Food Patterns Equivalents
Database components. Additionally, this package contains the Healthy
Eating Index (HEI) scoring standards that the heiscore package uses to
calculate HEI scores using three distinct methods prescribed by the
National Cancer Institute.

This package contains the following datasets:

- `fped_0506`: data from the 2005-06 NHANES cycle
- `fped_0708`: data from the 2007-08 NHANES cycle
- `fped_0910`: data from the 2009-10 NHANES cycle
- `fped_1112`: data from the 2011-12 NHANES cycle
- `fped_1314`: data from the 2013-14 NHANES cycle
- `fped_1516`: data from the 2015-16 NHANES cycle
- `fped_1718`: data from the 2017-18 NHANES cycle
- `fped_1720`: data from the 2017-March 2020 Pre-pandemic NHANES cycle
- `HEI_scoring_standards`: standards to achieve the maximum component
  HEI scores for individuals ages 2 years or older
- `HEI_scoring_standards_toddlers`: standards to achieve the maximum
  component HEI scores for individuals ages 12 through 23 months

## Installation

``` r
# Install the heiscore package from CRAN
install.packages("heiscore.data")
```

## Example

Import a dataset from the heiscore.data package.

``` r
library(heiscore.data)
data('fped_0708')
```
