% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgwr.R
\name{print.summary.hgwrm}
\alias{print.summary.hgwrm}
\title{Print summary of an \code{hgwrm} object.}
\usage{
\method{print}{summary.hgwrm}(x, decimal.fmt = "\%.6f", ...)
}
\arguments{
\item{x}{An object returned from \code{\link[=summary.hgwrm]{summary.hgwrm()}}.}

\item{decimal.fmt}{The format string passing to \code{\link[base:sprintf]{base::sprintf()}}.}

\item{...}{
  Arguments passed on to \code{\link[=print_table_md]{print_table_md}}
  \describe{
    \item{\code{col_sep}}{Column separator. Default to \code{""}.}
    \item{\code{header_sep}}{Header separator. Default to \code{"-"}.
If \code{header_sep} only contains one character,
it will be repeated for each column.
If it contains more than one character,
it will be printed below the first row.}
    \item{\code{row_begin}}{Character at the beginning of each row.
Default to \code{col_sep}.}
    \item{\code{row_end}}{Character at the ending of each row.
Default to \code{col_sep}.}
    \item{\code{table_before}}{Characters to be printed before the table.}
    \item{\code{table_after}}{Characters to be printed after the table.}
    \item{\code{table_style}}{Name of pre-defined style.
Possible values are \code{"plain"}, \code{"md"}, \code{"latex"}, or \code{"booktabs"}.
Default to \code{"plain"}.}
  }}
}
\value{
No return.
}
\description{
Print summary of an \code{hgwrm} object.
}
\examples{
data(mulsam.test)
model <- hgwr(
  formula = y ~ L(g1 + g2) + x1 + (z1 | group),
  data = mulsam.test$data,
  coords = mulsam.test$coords,
  bw = 10
)
summary(model)

}
\seealso{
\code{\link[=summary.hgwrm]{summary.hgwrm()}}, \code{\link[=print_table_md]{print_table_md()}}.
}
