% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggloClust2D.R
\name{AggloClust2D}
\alias{AggloClust2D}
\alias{print.res2D}
\alias{summary.res2D}
\alias{plot.res2D}
\title{Perform Constrained 2D Agglomerative Clustering}
\usage{
AggloClust2D(counts, nbClust = NULL)

\method{print}{res2D}(x, ...)

\method{summary}{res2D}(object, ...)

\method{plot}{res2D}(x, ...)
}
\arguments{
\item{counts}{an object of class
\code{\link[InteractionSet:interactions]{InteractionSet}} obtained from the
function \code{\link{loadData}} or an object of class
\code{resdiff} obtained from
function \code{\link{performTest}}.}

\item{nbClust}{integer. Number of clusters to obtain. Set to \code{NULL} by
default.}

\item{x}{a \code{res2D} object to plot}

\item{...}{not used}

\item{object}{a \code{res2D} object to summarize}
}
\value{
An object of class \code{res2D} containing:
\item{tree}{an object of class \code{hclust}}
\item{nbClust}{the number of clusters corresponding either to the value
passed by the user or to the optimal level of clusters as provided by the
elbow heuristic}
\item{clustering}{obtained clustering}
}
\description{
This function performs a connectivity constrained 2D
agglomerative clustering using \code{scikit-learn} function
\code{AgglomerativeClustering} and outputs an object of class \code{hclust}
that stores the hierarchy of merges and value of criterion at each merge. It
also outputs the optimal level of the hierarchy with respect to the elbow
heuristic.
}
\examples{
data("pighic")
\donttest{
res2D <- AggloClust2D(pighic$data)
if (!is.null(res2D)) { # in case Python or modules are not available
  clusters <- res2D$clustering
  print(res2D)
  summary(res2D)
  plot(res2D)
}
}
}
\author{
Élise Jorge \email{elise.jorge@inrae.fr}\cr
Sylvain Foissac \email{sylvain.foissac@inrae.fr}\cr
Toby Dylan Hocking \email{toby.hocking@r-project.org}\cr
Pierre Neuvial \email{pierre.neuvial@math.univ-toulouse.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
