% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_chromosomes_length.R
\name{compute_chrom_length}
\alias{compute_chrom_length}
\alias{compute_chrom_length.GWAS_data}
\alias{compute_chrom_length.DE_data}
\alias{compute_chrom_length.CAN_data}
\title{Computes chromosomes' length}
\usage{
compute_chrom_length(x)

\method{compute_chrom_length}{GWAS_data}(x)

\method{compute_chrom_length}{DE_data}(x)

\method{compute_chrom_length}{CAN_data}(x)
}
\arguments{
\item{x}{Either a \code{GWAS_data}, \code{DE_data} or \code{CAN_data} object.}
}
\value{
A tibble with two columns: \code{chromosome} (chromosome name) and
\code{length} (chromosome length in base pair).
}
\description{
Computes the length (in bp) of each chromosome as the maximum
position of markers or genes on the chromosome.
}
\examples{
x <- get_example_data()

compute_chrom_length(GWAS_data(x[["GWAS"]]))
compute_chrom_length(DE_data(x[["DE"]]))
compute_chrom_length(CAN_data(x[["CAN"]]))
}
