% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_pga_char.R
\name{hs_pga_char}
\alias{hs_pga_char}
\title{Converts HS-PGA numerical scores to character values.}
\usage{
hs_pga_char(hs_pga_scores)
}
\arguments{
\item{hs_pga_scores}{Integer vector representing the HS-PGA scores (1: Clean,
2: Minimal, 3: Mild, 4: Moderate, 5: Severe, 6: Very Severe).}
}
\value{
A character vector representing the corresponding HS-PGA categories.
}
\description{
Converts HS-PGA numerical scores to character values.
}
\examples{
hs_pga_char(c(1, 2, 3, 4, 5, 6))
}
\references{
Marzano, A V et al. “Creation of a severity index for
hidradenitis suppurativa that includes a validated quality-of-life
measure: the HIDRAscore.” Journal of the European Academy of Dermatology
and Venereology : JEADV vol. 34,8 (2020): 1815-1821. doi:10.1111/jdv.16328
}
\seealso{
Other HS-PGA: 
\code{\link{hs_pga_num}()}
}
\concept{HS-PGA}
