% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readmsb.R
\name{read.ms}
\alias{read.ms}
\title{Read data generated by Hudson ms program
 
 Read data generated by 
\href{http://home.uchicago.edu/rhudson1/source/mksamples.html}{Hudson ms} 
program, either as Haplotypes or as SNPs.}
\usage{
read.ms(fname,what=c("SNP","Haplotype"))
}
\arguments{
\item{fname}{file name containing ms output}

\item{what}{whether to read ms output as SNPs or haplotypes}
}
\value{
alldat  a data frame with nloc+1 columns, the first being the population
 to which the individual belongs and the next being the genotypes, one column per locus; 
 and one row per (haploid) individual.
}
\description{
With argument what="SNP", each site is read as a SNP, with the ancestral allele encoded as 0 and the alternate 
allele encoded as 1.  If the ms output file contains several replicates, 
the different replicates will be collated together.  Hence, the number of loci is the sum of all
sites from all replicates.
}
\details{
With argument what="Haplotype", each different sequence from a replicate 
is read as a haplotype, 
by converting it first to a factor, and then to an integer. There will be as many loci 
as there are replicates, and the number of alleles per locus will be the number of different
haplotypes in the corresponding replicate.
}
\examples{
\dontrun{
  datH<-read.ms(system.file("extdata","2pops_asspop.txt",package="hierfstat"),what="Haplotype")
  dim(datH)
  head(datH[,1:10]
  datS<-read.ms(system.file("extdata","2pops_asspop.txt",package="hierfstat"),what="SNP")
  dim(datS)
  head(datS[,1:10])
  }
}
\references{
\href{https://academic.oup.com/bioinformatics/article-abstract/18/2/337/225783}{Hudson, R. R. (2002) Generating samples under a Wright-Fisher neutral model of genetic variation}. Bioinformatics 18 : 337-338.
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
