% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sexbiaseddisp.R
\name{sexbias.test}
\alias{sexbias.test}
\title{Test for sex biased dispersal}
\usage{
sexbias.test(dat,sex,nperm=NULL,test="mAIc",alternative="two.sided")
}
\arguments{
\item{dat}{a data frame with n.locs+1 columns and n.inds rows}

\item{sex}{a vector containing the individual's sex}

\item{nperm}{the number of permutation to carry out}

\item{test}{one of "mAIc" (default), "vAIc","FIS" or "FST"}

\item{alternative}{one of "two.sided" (default),"less" or "greater"}
}
\value{
call the function call

res the observation for each sex

statistic the observed statistic for the chosen test

p.value the p-value of the hypothesis
}
\description{
Test whether one
sex disperses more than the other using the method described in 
\href{https://onlinelibrary.wiley.com/doi/abs/10.1046/j.1365-294X.2002.01496.x}{Goudet etal. (2002)}
}
\examples{
  data(crocrussula)
  sexbias.test(crocrussula$genot,crocrussula$sex)
  dat<-qn2.read.fstat(system.file("extdata","qn2_sex.dat",package="hierfstat"))
  sexbias.test(dat[[1]],sex=dat[[2]])
  \dontrun{
  sexbias.test(crocrussula$genot,crocrussula$sex,nperm=1000)
  sexbias.test(dat[[1]],sex=dat[[2]],nperm=100,test="FST",alternative="greater")
  }
}
\references{
\href{https://onlinelibrary.wiley.com/doi/abs/10.1046/j.1365-294X.2002.01496.x}{Goudet J, Perrin N, Waser P (2002)} Tests for sex-biased dispersal 
 using bi-parentally inherited genetic markers 11, 1103:1114
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
