% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{SKK_test}
\alias{SKK_test}
\title{High-dimensional two-sample test (SKK) proposed by Srivastava, Katayama, and Kano(2013)}
\usage{
SKK_test(X, Y)
}
\arguments{
\item{X}{The data matrix (n by p) from the first population.}

\item{Y}{The data matrix (m by p) from the second population.}
}
\value{
A list consisting of the values of the test statistic and p-value.
}
\description{
This function implements the two-sample high-dimensional test proposed by Srivastava, Katayama, and Kano(2013).
}
\examples{
# Generate a simulated dataset and apply the SKK test
data <- buildData(n = 45, m =60, p = 300,
                 muX = rep(0,300), muY = rep(0,300),
                 dep = 'IND', S = 1, innov = rnorm)
SKK_test(data[[1]]$X, data[[1]]$Y)

# Apply the SKK test to the data for a GO term stored in GO_example
SKK_test(GO_example$X, GO_example$Y)
}
\references{
Srivastava, M. S., Katayama, S., and Kano, Y. (2013).
A two sample test in high dimensional data. Journal of Multivariate Analysis, 114:349-358.
}
